/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.sync;

import com.gitlab.mvysny.umn.core.FIFOBuffer;
import com.gitlab.mvysny.umn.core.LogRecord;
import com.gitlab.mvysny.umn.sync.GlobalLogClient;
import com.gitlab.mvysny.umn.sync.GlobalLogPusher;
import java.io.Closeable;
import java.net.ConnectException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\b\u0010\u000f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/gitlab/mvysny/umn/sync/GlobalLogPusher;", "Ljava/io/Closeable;", "globalLogClient", "Lcom/gitlab/mvysny/umn/sync/GlobalLogClient;", "buffer", "Lcom/gitlab/mvysny/umn/core/FIFOBuffer;", "Lcom/gitlab/mvysny/umn/core/LogRecord;", "(Lcom/gitlab/mvysny/umn/sync/GlobalLogClient;Lcom/gitlab/mvysny/umn/core/FIFOBuffer;)V", "closed", "", "pusherThread", "Ljava/lang/Thread;", "addAsync", "", "record", "close", "Companion", "umn-core"})
public final class GlobalLogPusher
implements Closeable {
    private boolean closed;
    private final Thread pusherThread;
    private final GlobalLogClient globalLogClient;
    private final FIFOBuffer<LogRecord> buffer;
    private static final Logger log;
    public static final Companion Companion;

    public final void addAsync(@NotNull LogRecord record) {
        Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
        this.buffer.append(record);
    }

    @Override
    public void close() {
        this.closed = true;
        this.pusherThread.join();
    }

    public GlobalLogPusher(@NotNull GlobalLogClient globalLogClient, @NotNull FIFOBuffer<LogRecord> buffer) {
        Intrinsics.checkParameterIsNotNull((Object)globalLogClient, (String)"globalLogClient");
        Intrinsics.checkParameterIsNotNull(buffer, (String)"buffer");
        this.globalLogClient = globalLogClient;
        this.buffer = buffer;
        this.globalLogClient.setAddCallback((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                buffer.poll();
            }
        }));
        this.pusherThread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"UMN Remote Log Pusher", (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GlobalLogPusher this$0;

            public final void invoke() {
                Function0<Unit> tryStartClient$ = new Function0<Unit>(this){
                    final /* synthetic */ pusherThread.1 this$0;

                    public final void invoke() {
                        try {
                            GlobalLogPusher.access$getGlobalLogClient$p(this.this$0.this$0).start();
                            Thread.sleep(100L);
                        }
                        catch (ConnectException e) {
                            GlobalLogPusher.access$getLog$cp().info("Failed to connect to the server", (Throwable)e);
                            Thread.sleep(1000L);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                };
                try {
                    while (!GlobalLogPusher.access$getClosed$p(this.this$0)) {
                        try {
                            if (!GlobalLogPusher.access$getGlobalLogClient$p(this.this$0).isStarted()) {
                                tryStartClient$.invoke();
                                continue;
                            }
                            LogRecord item = (LogRecord)GlobalLogPusher.access$getBuffer$p(this.this$0).peek();
                            if (item == null) {
                                Thread.sleep(100L);
                                continue;
                            }
                            GlobalLogPusher.access$getGlobalLogClient$p(this.this$0).addAsync(item);
                        }
                        catch (Throwable t) {
                            GlobalLogPusher.access$getLog$cp().error("Pusher Thread failure", t);
                            Thread.sleep(5000L);
                        }
                    }
                }
                catch (Throwable t) {
                    GlobalLogPusher.access$getLog$cp().error("Pusher Thread fatal failure", t);
                }
            }
            {
                this.this$0 = globalLogPusher;
                super(0);
            }
        }), (int)21, null);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(GlobalLogPusher.class);
    }

    @NotNull
    public static final /* synthetic */ GlobalLogClient access$getGlobalLogClient$p(GlobalLogPusher $this) {
        return $this.globalLogClient;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ boolean access$getClosed$p(GlobalLogPusher $this) {
        return $this.closed;
    }

    public static final /* synthetic */ void access$setClosed$p(GlobalLogPusher $this, boolean bl) {
        $this.closed = bl;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lcom/gitlab/mvysny/umn/sync/GlobalLogPusher$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log$annotations", "umn-core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void log$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

