/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.mvysny.umn.sync;

import com.gitlab.mvysny.umn.core.DocumentSerializer;
import com.gitlab.mvysny.umn.core.LogRecord;
import com.gitlab.mvysny.umn.core.TypeToClassResolver;
import com.gitlab.mvysny.umn.sync.GlobalLogClient;
import com.gitlab.mvysny.umn.sync.InMemoryGlobalLogClient;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ#\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001c2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/gitlab/mvysny/umn/sync/InMemoryGlobalLog;", "", "serializer", "Lcom/gitlab/mvysny/umn/core/DocumentSerializer;", "typeToClassResolver", "Lcom/gitlab/mvysny/umn/core/TypeToClassResolver;", "(Lcom/gitlab/mvysny/umn/core/DocumentSerializer;Lcom/gitlab/mvysny/umn/core/TypeToClassResolver;)V", "clients", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/gitlab/mvysny/umn/sync/InMemoryGlobalLogClient;", "log", "Lcom/gitlab/mvysny/umn/core/LogRecord;", "getLog$umn_core", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "getSerializer", "()Lcom/gitlab/mvysny/umn/core/DocumentSerializer;", "getTypeToClassResolver", "()Lcom/gitlab/mvysny/umn/core/TypeToClassResolver;", "add", "", "client", "record", "add$umn_core", "close", "close$umn_core", "newClient", "Lcom/gitlab/mvysny/umn/sync/GlobalLogClient;", "startClient", "", "retrieveLogFrom", "", "startClient$umn_core", "umn-core"})
public final class InMemoryGlobalLog {
    private final CopyOnWriteArrayList<InMemoryGlobalLogClient> clients;
    @NotNull
    private final CopyOnWriteArrayList<LogRecord> log;
    @NotNull
    private final DocumentSerializer serializer;
    @NotNull
    private final TypeToClassResolver typeToClassResolver;

    @NotNull
    public final CopyOnWriteArrayList<LogRecord> getLog$umn_core() {
        return this.log;
    }

    @NotNull
    public final GlobalLogClient newClient() {
        return new InMemoryGlobalLogClient(this);
    }

    @NotNull
    public final synchronized List<LogRecord> startClient$umn_core(@NotNull InMemoryGlobalLogClient client, long retrieveLogFrom) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.clients.add(client);
        List<LogRecord> list = this.log.subList((int)retrieveLogFrom, this.log.size());
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"log.subList(retrieveLogFrom.toInt(), log.size)");
        return list;
    }

    public final void close$umn_core(@NotNull InMemoryGlobalLogClient client) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.clients.remove(client);
    }

    public final synchronized void add$umn_core(@NotNull InMemoryGlobalLogClient client, @NotNull LogRecord record) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)record, (String)"record");
        this.log.add(record);
        client.getAddCallback$umn_core().invoke();
        Iterable $receiver$iv = this.clients;
        for (Object element$iv : $receiver$iv) {
            InMemoryGlobalLogClient it = (InMemoryGlobalLogClient)element$iv;
            it.onNewItem$umn_core(record);
        }
    }

    @NotNull
    public final DocumentSerializer getSerializer() {
        return this.serializer;
    }

    @NotNull
    public final TypeToClassResolver getTypeToClassResolver() {
        return this.typeToClassResolver;
    }

    public InMemoryGlobalLog(@NotNull DocumentSerializer serializer, @NotNull TypeToClassResolver typeToClassResolver) {
        Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
        Intrinsics.checkParameterIsNotNull((Object)typeToClassResolver, (String)"typeToClassResolver");
        this.serializer = serializer;
        this.typeToClassResolver = typeToClassResolver;
        this.clients = new CopyOnWriteArrayList();
        this.log = new CopyOnWriteArrayList();
    }
}

