/*
 * Decompiled with CFR 0.152.
 */
package com.gnepux.wsgo;

import com.gnepux.wsgo.EventListener;
import com.gnepux.wsgo.protocol.WebSocket;
import com.gnepux.wsgo.retry.DefaultRetryStrategy;
import com.gnepux.wsgo.retry.RetryStrategy;
import com.gnepux.wsgo.util.WsGoLog;
import java.util.HashMap;

public class WsConfig {
    public String url;
    public HashMap<String, String> httpHeaders;
    public WebSocket websocket;
    public long pingInterval;
    public long connectTimeout;
    public long readTimeout;
    public long writeTimeout;
    public RetryStrategy retryStrategy;
    public EventListener eventListener;

    private WsConfig(Builder builder) {
        this.url = builder.url;
        this.httpHeaders = builder.httpHeaders;
        this.websocket = builder.websocket;
        this.pingInterval = builder.pingInterval;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.retryStrategy = builder.retryStrategy;
        this.eventListener = builder.eventListener;
        WsGoLog.DEBUG = builder.debug;
    }

    public static class Builder {
        String url;
        HashMap<String, String> httpHeaders;
        WebSocket websocket;
        long pingInterval = 30000L;
        long connectTimeout = 6000L;
        long readTimeout = 10000L;
        long writeTimeout = 10000L;
        RetryStrategy retryStrategy;
        EventListener eventListener;
        boolean debug = true;

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setHttpHeaders(HashMap<String, String> headers) {
            this.httpHeaders = headers;
            return this;
        }

        public Builder setWebSocket(WebSocket webSocket) {
            this.websocket = webSocket;
            return this;
        }

        public Builder setPingInterval(long pingInterval) {
            this.pingInterval = pingInterval;
            return this;
        }

        public Builder setConnectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(long readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setWriteTimeout(long writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public Builder setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public Builder setEventListener(EventListener listener) {
            this.eventListener = listener;
            return this;
        }

        public Builder debugMode(boolean debug) {
            this.debug = debug;
            return this;
        }

        public WsConfig build() {
            if (this.url == null) {
                throw new IllegalStateException("url == null");
            }
            if (this.websocket == null) {
                throw new IllegalStateException("websocket == null");
            }
            if (this.httpHeaders == null) {
                this.httpHeaders = new HashMap();
            }
            if (this.retryStrategy == null) {
                this.retryStrategy = new DefaultRetryStrategy();
            }
            return new WsConfig(this);
        }
    }
}

