/*
 * Decompiled with CFR 0.152.
 */
package com.gnepux.wsgo;

import com.gnepux.wsgo.WsConfig;
import com.gnepux.wsgo.dispatch.dispatcher.Dispatcher;
import com.gnepux.wsgo.dispatch.message.command.ChangePingCmd;
import com.gnepux.wsgo.dispatch.message.command.Command;
import com.gnepux.wsgo.dispatch.message.command.ConnectCmd;
import com.gnepux.wsgo.dispatch.message.command.DisconnectCmd;
import com.gnepux.wsgo.dispatch.message.command.SendCmd;
import com.gnepux.wsgo.dispatch.message.event.Event;
import com.gnepux.wsgo.dispatch.resolver.CommandResolver;
import com.gnepux.wsgo.dispatch.resolver.EventResolver;
import com.gnepux.wsgo.util.WsGoLog;
import java.util.concurrent.TimeUnit;

public class WsGo {
    private WsConfig config;
    private Dispatcher<Command> commandDispatcher;
    private Dispatcher<Event> eventDispatcher;
    private static volatile WsGo sInstance;

    private WsGo(WsConfig config) {
        this.config = config;
        this.commandDispatcher = new Dispatcher();
        this.eventDispatcher = new Dispatcher();
        CommandResolver commandResolver = new CommandResolver(this.eventDispatcher);
        EventResolver eventResolver = new EventResolver(config.eventListener, this.commandDispatcher);
        this.commandDispatcher.loop("command", commandResolver);
        this.eventDispatcher.loop("event", eventResolver);
        WsGoLog.d("WsGo init success");
    }

    public static synchronized void init(WsConfig config) {
        if (config == null) {
            WsGoLog.d("WsGo init failed: config can not be null");
            return;
        }
        if (sInstance == null) {
            sInstance = new WsGo(config);
        }
    }

    public static WsGo getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("WsGo must call init() first.");
        }
        return sInstance;
    }

    public void destroyInstance() {
        this.disconnectNormal("WsGo destroy");
        this.commandDispatcher.stop();
        this.eventDispatcher.stop();
        sInstance = null;
        WsGoLog.d("WsGo destroy");
    }

    public void connect() {
        if (this.config != null) {
            this.commandDispatcher.sendMessage(new ConnectCmd(this.config));
        }
    }

    public void disconnect(int code, String reason) {
        if (code < 1000 || code > 4999) {
            return;
        }
        this.commandDispatcher.sendMessage(new DisconnectCmd(code, reason));
    }

    public void disconnectNormal(String reason) {
        this.disconnect(1000, reason);
    }

    public void changePingInterval(long interval, TimeUnit unit) {
        this.commandDispatcher.sendMessage(new ChangePingCmd(interval, unit));
    }

    public void send(String text) {
        this.commandDispatcher.sendMessage(new SendCmd(text));
    }
}

