/*
 * Decompiled with CFR 0.152.
 */
package com.gnepux.wsgo.dispatch.consumer;

import com.gnepux.wsgo.dispatch.consumer.Consumer;
import com.gnepux.wsgo.dispatch.message.Message;
import com.gnepux.wsgo.dispatch.queue.MessageQueue;
import com.gnepux.wsgo.dispatch.resolver.Resolver;

public class ConsumerThread<E extends Message>
extends Thread
implements Consumer<E> {
    private Resolver<E> resolver;
    private volatile boolean isAlive;
    private MessageQueue<E> queue;

    public ConsumerThread(String name, MessageQueue<E> queue, Resolver<E> resolver) {
        super(name);
        this.queue = queue;
        this.isAlive = true;
        this.resolver = resolver;
    }

    @Override
    public void run() {
        while (this.isAlive) {
            Object e = this.queue.poll();
            if (e == null) continue;
            this.handleMessage(e);
        }
    }

    public void shutdown() {
        this.isAlive = false;
        this.interrupt();
    }

    @Override
    public void handleMessage(E e) {
        this.resolver.resolve(e);
    }
}

