/*
 * Decompiled with CFR 0.152.
 */
package com.gnepux.wsgo.dispatch.dispatcher;

import com.gnepux.wsgo.dispatch.consumer.ConsumerThread;
import com.gnepux.wsgo.dispatch.message.Message;
import com.gnepux.wsgo.dispatch.producer.Producer;
import com.gnepux.wsgo.dispatch.producer.ProducerThread;
import com.gnepux.wsgo.dispatch.queue.MessageQueue;
import com.gnepux.wsgo.dispatch.resolver.Resolver;

public class Dispatcher<E extends Message>
implements Producer<E> {
    private Producer<E> producerProxy;
    private ProducerThread<E> producerThread;
    private ConsumerThread<E> consumerThread;

    public void loop(String type, Resolver<E> resolver) {
        MessageQueue queue = new MessageQueue();
        this.producerThread = new ProducerThread("wsgo-" + type + "-producer", queue);
        this.consumerThread = new ConsumerThread("wsgo-" + type + "-consumer", queue, resolver);
        this.producerThread.start();
        this.consumerThread.start();
        this.setProxy(this.producerThread);
    }

    private void setProxy(Producer<E> producer) {
        this.producerProxy = producer;
    }

    public void stop() {
        this.producerThread.shutdown();
        this.consumerThread.shutdown();
    }

    @Override
    public void sendMessage(E e) {
        this.producerProxy.sendMessage(e);
    }

    @Override
    public void sendMessageDelay(E message, long delay) {
        this.producerProxy.sendMessageDelay(message, delay);
    }
}

