/*
 * Decompiled with CFR 0.152.
 */
package com.gnepux.wsgo.dispatch.resolver;

import com.gnepux.wsgo.dispatch.dispatcher.Dispatcher;
import com.gnepux.wsgo.dispatch.message.command.ChangePingCmd;
import com.gnepux.wsgo.dispatch.message.command.Command;
import com.gnepux.wsgo.dispatch.message.command.ConnectCmd;
import com.gnepux.wsgo.dispatch.message.command.DisconnectCmd;
import com.gnepux.wsgo.dispatch.message.command.ReconnectCmd;
import com.gnepux.wsgo.dispatch.message.command.SendCmd;
import com.gnepux.wsgo.dispatch.message.event.Event;
import com.gnepux.wsgo.dispatch.resolver.Resolver;
import com.gnepux.wsgo.protocol.ChannelManager;

public class CommandResolver
implements Resolver<Command> {
    private ChannelManager mChannelManager;

    public CommandResolver(Dispatcher<Event> eventDispatcher) {
        this.mChannelManager = new ChannelManager(eventDispatcher);
    }

    @Override
    public void resolve(Command command) {
        int cmd = command.getCmd();
        switch (cmd) {
            case 1: {
                this.handleConnect((ConnectCmd)command);
                break;
            }
            case 3: {
                this.handleReconnect((ReconnectCmd)command);
                break;
            }
            case 2: {
                this.handleDisconnect((DisconnectCmd)command);
                break;
            }
            case 4: {
                this.handleChangePing((ChangePingCmd)command);
                break;
            }
            case 5: {
                this.handleSend((SendCmd)command);
            }
        }
    }

    private void handleConnect(ConnectCmd command) {
        this.mChannelManager.connect(command.getConfig().websocket, command.getConfig(), false);
    }

    private void handleReconnect(ReconnectCmd command) {
        this.mChannelManager.reconnect(command.getRetryCount());
    }

    private void handleDisconnect(DisconnectCmd command) {
        this.mChannelManager.disconnect(command.getCode(), command.getReason());
    }

    private void handleChangePing(ChangePingCmd command) {
        this.mChannelManager.changePingInterval(command.getTime(), command.getUnit());
    }

    private void handleSend(SendCmd command) {
        this.mChannelManager.send(command.getText());
    }
}

