/*
 * Decompiled with CFR 0.152.
 */
package com.gnepux.wsgo.dispatch.resolver;

import com.gnepux.wsgo.EventListener;
import com.gnepux.wsgo.dispatch.dispatcher.Dispatcher;
import com.gnepux.wsgo.dispatch.message.command.Command;
import com.gnepux.wsgo.dispatch.message.command.ReconnectCmd;
import com.gnepux.wsgo.dispatch.message.event.Event;
import com.gnepux.wsgo.dispatch.message.event.OnCloseEvent;
import com.gnepux.wsgo.dispatch.message.event.OnDisConnectEvent;
import com.gnepux.wsgo.dispatch.message.event.OnMessageEvent;
import com.gnepux.wsgo.dispatch.message.event.OnRetryEvent;
import com.gnepux.wsgo.dispatch.message.event.OnSendEvent;
import com.gnepux.wsgo.dispatch.resolver.Resolver;

public class EventResolver
implements Resolver<Event> {
    private EventListener listener;
    private Dispatcher<Command> commandDispatcher;

    public EventResolver(EventListener listener, Dispatcher<Command> commandDispatcher) {
        this.listener = listener;
        this.commandDispatcher = commandDispatcher;
    }

    @Override
    public void resolve(Event event) {
        switch (event.getEvent()) {
            case 1: {
                this.listener.onConnect();
                break;
            }
            case 2: {
                this.listener.onDisConnect(((OnDisConnectEvent)event).getThrowable());
                break;
            }
            case 4: {
                OnCloseEvent onCloseEvent = (OnCloseEvent)event;
                this.listener.onClose(onCloseEvent.getCode(), onCloseEvent.getReason());
                break;
            }
            case 5: {
                this.listener.onMessage(((OnMessageEvent)event).getText());
                break;
            }
            case 6: {
                OnRetryEvent retryEvent = (OnRetryEvent)event;
                this.listener.onReconnect(retryEvent.getRetryCount(), retryEvent.getDelayMillSec());
                this.commandDispatcher.sendMessageDelay(new ReconnectCmd(retryEvent.getRetryCount()), retryEvent.getDelayMillSec());
                break;
            }
            case 7: {
                OnSendEvent sendEvent = (OnSendEvent)event;
                this.listener.onSend(sendEvent.getText(), sendEvent.isSuccess());
                break;
            }
        }
    }
}

