/*
 * Decompiled with CFR 0.152.
 */
package com.gnepux.wsgo.protocol;

import com.gnepux.wsgo.WsConfig;
import com.gnepux.wsgo.dispatch.dispatcher.Dispatcher;
import com.gnepux.wsgo.dispatch.message.event.Event;
import com.gnepux.wsgo.dispatch.message.event.OnCloseEvent;
import com.gnepux.wsgo.dispatch.message.event.OnConnectEvent;
import com.gnepux.wsgo.dispatch.message.event.OnDisConnectEvent;
import com.gnepux.wsgo.dispatch.message.event.OnMessageEvent;
import com.gnepux.wsgo.dispatch.message.event.OnRetryEvent;
import com.gnepux.wsgo.dispatch.message.event.OnSendEvent;
import com.gnepux.wsgo.protocol.ChannelCallback;
import com.gnepux.wsgo.protocol.WebSocket;
import com.gnepux.wsgo.util.WsGoLog;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ChannelManager
implements ChannelCallback {
    private WebSocket mWebSocket;
    private volatile STATE state = STATE.IDLE;
    private Dispatcher<Event> eventDispatcher;
    private volatile long retryCount = 0L;
    private WsConfig mConfig;
    private CountDownLatch latch;
    private volatile long lastRetryTimeStamp;
    private volatile long lastDelayTime;

    public ChannelManager(Dispatcher<Event> eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    public void connect(WebSocket webSocket, WsConfig config, boolean reConnect) {
        WsGoLog.d("[connect] reConnect=[" + reConnect + "]");
        if (this.state == STATE.CONNECTED) {
            return;
        }
        if (webSocket == null || config == null) {
            return;
        }
        this.latch = new CountDownLatch(1);
        this.state = STATE.CONNECTING;
        try {
            this.mWebSocket = webSocket;
            this.mConfig = config;
            if (reConnect) {
                webSocket.reconnect(config, this);
            } else {
                webSocket.connect(config, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.state = STATE.IDLE;
        }
        try {
            this.latch.await(config.connectTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void reconnect(long retryCount) {
        WsGoLog.d("[reconnect] retryCount=[" + retryCount + "]");
        if (this.state == STATE.CONNECTED) {
            WsGoLog.d("[reconnect] WsGo has been connected. skip");
            return;
        }
        this.connect(this.mWebSocket, this.mConfig, true);
    }

    public void disconnect(int code, String reason) {
        WsGoLog.d("[disconnect] code=[" + code + "] reason=[" + reason + "]");
        if (this.mWebSocket != null) {
            this.mWebSocket.disconnect(code, reason);
            this.mWebSocket = null;
        }
    }

    public void changePingInterval(long time, TimeUnit unit) {
        WsGoLog.d("[changePingInterval] time=[" + time + "] unit=[" + unit.toString() + "]");
        if (this.mWebSocket != null) {
            this.mWebSocket.changePingInterval(time, unit);
        }
    }

    public void send(String text) {
        WsGoLog.d("[send] " + text);
        boolean success = false;
        if (this.mWebSocket != null) {
            success = this.mWebSocket.send(text);
        }
        this.eventDispatcher.sendMessage(new OnSendEvent(success, text));
    }

    @Override
    public void onConnect(WebSocket webSocket) {
        WsGoLog.d("[onConnect] connect success");
        this.eventDispatcher.sendMessage(new OnConnectEvent());
        this.state = STATE.CONNECTED;
        this.retryCount = 0L;
        this.mWebSocket = webSocket;
        this.latch.countDown();
    }

    @Override
    public void onMessage(String text) {
        WsGoLog.d("[onMessage] " + text);
        this.eventDispatcher.sendMessage(new OnMessageEvent(text));
    }

    @Override
    public void onClose(int code, String reason) {
        WsGoLog.d("[onClose] code=[" + code + "] reason=[" + reason + "]");
        this.eventDispatcher.sendMessage(new OnCloseEvent(code, reason));
        this.state = STATE.IDLE;
        if (code != 1000) {
            this.sendReconnectMsg();
        }
        this.latch.countDown();
    }

    @Override
    public void onDisconnect(Throwable t) {
        WsGoLog.d("[onDisconnect] " + t.getMessage());
        this.eventDispatcher.sendMessage(new OnDisConnectEvent(t));
        this.state = STATE.IDLE;
        this.sendReconnectMsg();
        this.latch.countDown();
    }

    private synchronized void sendReconnectMsg() {
        long retryTime = System.currentTimeMillis();
        if (retryTime - this.lastRetryTimeStamp < this.lastDelayTime) {
            WsGoLog.d("retry request too frequent, skip");
            return;
        }
        this.lastRetryTimeStamp = retryTime;
        this.lastDelayTime = this.mConfig.retryStrategy.onRetry(this.retryCount);
        WsGoLog.d(this.retryCount + " times reconnect try after " + this.lastDelayTime + "ms");
        OnRetryEvent onRetry = new OnRetryEvent(this.retryCount++, this.lastDelayTime);
        this.eventDispatcher.sendMessage(onRetry);
    }

    public static enum STATE {
        IDLE,
        CONNECTING,
        CONNECTED;

    }
}

