/*
 * ProGuardCORE -- library to process Java bytecode.
 *
 * Copyright (c) 2002-2020 Guardsquare NV
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package proguard.classfile;

/**
 * Known external version numbers of class files.
 *
 * @see VersionConstants
 *
 * @author Eric Lafortune
 */
public class JavaVersionConstants
{
    public static final String CLASS_VERSION_1_0       = "1.0";
    public static final String CLASS_VERSION_1_1       = "1.1";
    public static final String CLASS_VERSION_1_2       = "1.2";
    public static final String CLASS_VERSION_1_3       = "1.3";
    public static final String CLASS_VERSION_1_4       = "1.4";
    public static final String CLASS_VERSION_1_5       = "1.5";
    public static final String CLASS_VERSION_1_6       = "1.6";
    public static final String CLASS_VERSION_1_7       = "1.7";
    public static final String CLASS_VERSION_1_8       = "1.8";
    public static final String CLASS_VERSION_1_9       = "1.9";
    public static final String CLASS_VERSION_1_5_ALIAS = "5";
    public static final String CLASS_VERSION_1_6_ALIAS = "6";
    public static final String CLASS_VERSION_1_7_ALIAS = "7";
    public static final String CLASS_VERSION_1_8_ALIAS = "8";
    public static final String CLASS_VERSION_1_9_ALIAS = "9";
    public static final String CLASS_VERSION_10        = "10";
    public static final String CLASS_VERSION_11        = "11";
    public static final String CLASS_VERSION_12        = "12";
    public static final String CLASS_VERSION_13        = "13";
    public static final String CLASS_VERSION_14        = "14";
    public static final String CLASS_VERSION_15        = "15";
    public static final String CLASS_VERSION_16        = "16";
}
