package com.hyprmx.android.sdk.activity

import android.graphics.Color
import android.os.Bundle
import android.view.View
import android.view.ViewGroup
import android.widget.RelativeLayout
import androidx.appcompat.app.AppCompatActivity
import com.hyprmx.android.R
import com.hyprmx.android.sdk.analytics.ClientErrorControllerIf
import com.hyprmx.android.sdk.api.data.Ad
import com.hyprmx.android.sdk.fullscreen.FullScreenSharedInterface
import com.hyprmx.android.sdk.network.NetworkConnectionMonitor
import com.hyprmx.android.sdk.om.OpenMeasurementController
import com.hyprmx.android.sdk.powersavemode.PowerSaveModeListener
import com.hyprmx.android.sdk.presentation.ActivityResultListener
import com.hyprmx.android.sdk.presentation.PresentationEventPublisher
import com.hyprmx.android.sdk.utility.HyprMXErrorType
import com.hyprmx.android.sdk.utility.HyprMXLog
import com.hyprmx.android.sdk.utility.InternetConnectionDialog
import com.hyprmx.android.sdk.webview.WebViewFactoryIf
import kotlinx.coroutines.CoroutineScope

internal class HyprMXBaseFullScreenWebViewController(
  activity: AppCompatActivity,
  savedInstanceState: Bundle?,
  val ad: Ad,
  hyprMXBaseViewControllerListener: HyprMXBaseViewControllerListener,
  webViewFactory: WebViewFactoryIf,
  private val clientErrorController: ClientErrorControllerIf,
  activityResultListener: ActivityResultListener,
  openMeasurementController: OpenMeasurementController?,
  powerSaveMode: PowerSaveModeListener,
  scope: CoroutineScope,
  networkConnectionMonitor: NetworkConnectionMonitor,
  internetConnectionDialog: InternetConnectionDialog,
  eventPublisher: PresentationEventPublisher,
  fullScreenSharedConnector: FullScreenSharedInterface,
) :
  HyprMXBaseViewController(
    activity = activity,
    savedInstanceState = savedInstanceState,
    hyprMXBaseViewControllerListener = hyprMXBaseViewControllerListener,
    activityResultListener = activityResultListener,
    powerSaveMode = powerSaveMode,
    webViewFactory = webViewFactory,
    openMeasurementController = openMeasurementController,
    baseAd = ad,
    scope = scope,
    networkConnectionMonitor = networkConnectionMonitor,
    internetConnectionDialog = internetConnectionDialog,
    eventPublisher = eventPublisher,
    fullScreenSharedConnector = fullScreenSharedConnector,
  ) {
  private lateinit var offerContainer: RelativeLayout

  private var fullScreenVideoContainer: RelativeLayout? = null

  override fun restoreState(savedInstanceState: Bundle) {
    super.restoreState(savedInstanceState)

    if (payoutComplete) {
      when {
        thankYouUrl != null -> {
          HyprMXLog.d("loading thank you url")
          thankYouUrl?.let { webView.loadUrl(it) }
        }
        else -> {
          clientErrorController.sendClientError(
            HyprMXErrorType.HYPRErrorTypeSDKInternalError,
            "thank you url cannot be null, when payout is complete.",
            ClientErrorControllerIf.SEVERITY_4,
          )
          finishWithResult()
        }
      }
    } else {
      finishWithResult()
    }
    return
  }

  override fun getOfferRootLayout(): ViewGroup {
    return offerContainer
  }

  override fun setupLayout() {
    super.setupLayout()
    offerContainer = RelativeLayout(activity)
    offerContainer.id = R.id.hyprmx_offer_container
    offerContainer.setBackgroundColor(Color.BLACK)
    rootLayout.addView(offerContainer, rootLayoutParams)

    // setup webview
    webView.id = R.id.hyprmx_primary_web_view
    webView.setBackgroundColor(Color.BLACK)
    offerContainer.addView(webView, rootLayoutParams)

    // setup RelativeLayout for full screen video
    fullScreenVideoContainer = RelativeLayout(activity)
    fullScreenVideoContainer!!.id = R.id.hyprmx_full_screen_video_container
    fullScreenVideoContainer!!.visibility = View.INVISIBLE
    fullScreenVideoContainer!!.setBackgroundColor(Color.BLACK)
    rootLayout.addView(
      fullScreenVideoContainer,
      RelativeLayout.LayoutParams(
        RelativeLayout.LayoutParams.MATCH_PARENT,
        RelativeLayout.LayoutParams.MATCH_PARENT,
      ),
    )
  }

  override fun executeJS(script: String) {
    webView.loadUrl("javascript:$script")
  }
}
