package com.hyprmx.android.sdk.activity

import com.hyprmx.android.sdk.api.data.UiComponents
import com.hyprmx.android.sdk.presentation.ActivityResultListener
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

internal class HyprMXNoAdViewController(
  private val activityResultListener: ActivityResultListener,
  val uiComponents: UiComponents,
  private val scope: CoroutineScope,
) : CoroutineScope by scope {
  fun onAdDismissed(wasCompleted: Boolean) {
    launch {
      activityResultListener.onAdDismissed(wasCompleted)
    }
  }
}

internal interface HyprMXNoAdViewControllerFactory {
  fun createHyprMXNoAdActivityController(activity: HyprMXNoOffersActivity): HyprMXNoAdViewController
}

internal class DefaultHyprMXNoAdViewControllerFactory(
  val activityResultListener: ActivityResultListener,
  val uiComponents: UiComponents,
  val scope: CoroutineScope,
) : HyprMXNoAdViewControllerFactory {
  override fun createHyprMXNoAdActivityController(activity: HyprMXNoOffersActivity): HyprMXNoAdViewController {
    return HyprMXNoAdViewController(
      activityResultListener = activityResultListener,
      uiComponents = uiComponents,
      scope = scope,
    )
  }
}
