package com.hyprmx.android.sdk.activity

import com.hyprmx.android.sdk.api.data.RequiredInformation
import com.hyprmx.android.sdk.api.data.UiComponents
import com.hyprmx.android.sdk.presentation.ActivityResultListener
import com.hyprmx.android.sdk.utility.ImageCacheManagerIf
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import org.json.JSONObject

internal class HyprMXRequiredInfoViewController(
  private val activityResultListener: ActivityResultListener,
  val imageCacheManager: ImageCacheManagerIf,
  val uiComponents: UiComponents,
  val requiredInformation: List<RequiredInformation>,
  private val scope: CoroutineScope,
) : CoroutineScope by scope {

  fun requiredInfoPresentationCompletedWithParams(requiredInfo: Map<String, String>) {
    launch {
      activityResultListener.requiredInfoPresentationCompletedWithParams(JSONObject(requiredInfo).toString())
    }
  }

  fun requiredInfoPresentationCancelled() {
    launch {
      activityResultListener.requiredInfoPresentationCancelled()
    }
  }

  fun onAdDismissed(wasCompleted: Boolean) {
    launch {
      activityResultListener.onAdDismissed(wasCompleted)
    }
  }
}

internal interface HyprMXRequiredInfoControllerFactory {
  fun createRequiredActivityController(activity: HyprMXRequiredInformationActivity): HyprMXRequiredInfoViewController
}

internal class DefaultHyprMXRequiredInfoControllerFactory(
  val activityResultListener: ActivityResultListener,
  val imageCacheManager: ImageCacheManagerIf,
  val uiComponents: UiComponents,
  val requiredInformation: List<RequiredInformation>,
  val scope: CoroutineScope,
) : HyprMXRequiredInfoControllerFactory {
  override fun createRequiredActivityController(activity: HyprMXRequiredInformationActivity): HyprMXRequiredInfoViewController {
    return HyprMXRequiredInfoViewController(
      activityResultListener = activityResultListener,
      imageCacheManager = imageCacheManager,
      uiComponents = uiComponents,
      requiredInformation = requiredInformation,
      scope = scope,
    )
  }
}
