package com.hyprmx.android.sdk.analytics

import com.hyprmx.android.sdk.core.js.JSEngine
import com.hyprmx.android.sdk.utility.HyprMXErrorType

interface ClientErrorControllerIf {
  fun sendClientError(hyprMXErrorType: HyprMXErrorType, errorMessage: String, severity: Int)

  companion object {
    const val SEVERITY_1 = 1
    const val SEVERITY_2 = 2
    const val SEVERITY_3 = 3
    const val SEVERITY_4 = 4
    const val SEVERITY_5 = 5 // 5 is the highest severity level

    const val DEFAULT_SEVERITY = SEVERITY_3
  }
}

/**
 * This controller is responsible for creating Error Captures and sending them off to the server
 * [errorReportingEndpoint] The end point to report to
 * [errorSeverityLevel] The minimum severity to report
 * [queryParams] The additional query params to report
 */
internal class ClientErrorController(
  private val jsEngine: JSEngine,
) :
  ClientErrorControllerIf {

  override fun sendClientError(
    hyprMXErrorType: HyprMXErrorType,
    errorMessage: String,
    severity: Int,
  ) {
    sendClientError(hyprMXErrorType.name, errorMessage, severity)
  }

  private fun sendClientError(
    errorSummary: String,
    errorMessage: String,
    severity: Int,
  ) {
    jsEngine.evaluateScriptForResponse("dispatchCEC({ message:'$errorMessage', type:'$errorSummary', severity:$severity })")
  }
}
