package com.hyprmx.android.sdk.analytics

import android.os.Build
import android.os.Build.PRODUCT
import com.hyprmx.android.sdk.analytics.ParameterControllerImpl.Companion.PLATFORM
import com.hyprmx.android.sdk.annotation.RetainMethodSignature
import com.hyprmx.android.sdk.core.hyprmxDelegate
import com.hyprmx.android.sdk.utility.HyprMXProperties

/**
 * Collect a set of base parameters and returns it to the JS callback.
 */
internal interface ParamsNativeInterface {

  @RetainMethodSignature
  fun getUnityParams(): String

  @RetainMethodSignature
  fun getMediationParams(): String

  @RetainMethodSignature
  fun getMraidSupportsString(): String

  @RetainMethodSignature
  fun getScreenSize(): String

  @RetainMethodSignature
  fun getMaxFrameSize(): String

  @RetainMethodSignature
  fun getIsLowPowerEnabled(): Boolean

  @RetainMethodSignature
  fun getPlatform() = PLATFORM

  @RetainMethodSignature
  fun getDistributorID() = hyprmxDelegate.hyprMXController?.distributorId ?: ""

  @RetainMethodSignature
  fun getMSDKV() = HyprMXProperties.buildNumber

  @RetainMethodSignature
  fun getSDKVersion() = HyprMXProperties.version

  @RetainMethodSignature
  fun getOSVersion(): String = Build.VERSION.RELEASE

  @RetainMethodSignature
  fun getDeviceModel(): String = Build.MODEL

  @RetainMethodSignature
  fun getDeviceType(): String = "android"

  @RetainMethodSignature
  fun getDeviceWidth(): Int

  @RetainMethodSignature
  fun getDeviceHeight(): Int

  @RetainMethodSignature
  fun getPxRatio(): Float

  @RetainMethodSignature
  fun getConnectionType(): String

  @RetainMethodSignature
  fun getBundleID(): String

  @RetainMethodSignature
  fun getBundleVersion(): String

  @RetainMethodSignature
  fun getClearTextPermitted(): Boolean

  @RetainMethodSignature
  fun getAdIdOptedOut(): Boolean

  @RetainMethodSignature
  fun getPersistentID(): String?

  @RetainMethodSignature
  fun getGAID(): String?

  @RetainMethodSignature
  fun getIsAgeRestrictedUser(): Boolean

  @RetainMethodSignature
  fun getUserPermissions(): String

  @RetainMethodSignature
  fun getPermissions(): String

  /**
   * Gets a list of carriers as an array with the first being the active carrier
   * [{name, mcc, mnc}]
   */
  @RetainMethodSignature
  fun getCarriers(): String

  @RetainMethodSignature
  fun getSupportsMultipleWindow() = false

  // Android Only
  @RetainMethodSignature
  fun getAndroidId(): String

  @RetainMethodSignature
  fun getDeviceFingerPrint(): String = Build.FINGERPRINT

  @RetainMethodSignature
  fun getDeviceManufacturer(): String = Build.MANUFACTURER

  @RetainMethodSignature
  fun getDeviceBrand(): String = Build.BRAND

  @RetainMethodSignature
  fun getDevice(): String = Build.DEVICE

  @RetainMethodSignature
  fun getDeviceProduct(): String = PRODUCT

  @RetainMethodSignature
  fun getTargetSDKVersion(): Float

  // iOS Only
  @RetainMethodSignature
  fun getPrivacyTrackingStatus(): Nothing? = null

  @RetainMethodSignature
  fun getSupportedInterfaceSettings(): Nothing? = null

  @RetainMethodSignature
  fun getATSSettings(): Nothing? = null

  @RetainMethodSignature
  fun getMacCatalyst(): Nothing? = null

  @RetainMethodSignature
  fun getIOSAppOnMac(): Nothing? = null

  @RetainMethodSignature
  fun getIdentifierForVendor(): Nothing? = null

  @RetainMethodSignature
  fun getXcodeVersion(): Nothing? = null

  @RetainMethodSignature
  fun getSupportsMultipleScenes(): Nothing? = null

  @RetainMethodSignature
  fun getSKAdNetworkItems(): Nothing? = null

  @RetainMethodSignature
  fun getScreenTraits(): Nothing? = null

  @RetainMethodSignature
  fun getUserExtra(key: String): String?

  @RetainMethodSignature
  fun getUserExtras(): String

  @RetainMethodSignature
  fun isTestModeEnabled(): Boolean
}
