package com.hyprmx.android.sdk.api.data

import com.hyprmx.android.sdk.utility.HyprMXLog
import org.json.JSONException
import org.json.JSONObject

/**
 * Represents the "ui_components" component as returned from the HyprMX
 * `offers_available` endpoint.
 *
 * This class is immutable.
 *
 * @version $Revision: 1.0 $
 */
internal class UiComponents(val noAd: NoAd, val userInfoForm: UserInfoForm) {
  companion object {

    /**
     * Converts the json into UiComponents.
     * If there is issue converting, it will return the defaults.
     */
    fun fromJson(jsonString: String?): UiComponents {
      if (jsonString == null) {
        return UiComponents(NoAd.getDefaultNoAd(), UserInfoForm.getDefaultUserInfoForm())
      }

      return try {
        val json = JSONObject(jsonString)

        val userInfoForm: UserInfoForm = if (json.has(FIELD_USER_INFO_FORM)) {
          UserInfoForm.fromJson(json.getJSONObject(FIELD_USER_INFO_FORM))
        } else {
          UserInfoForm.getDefaultUserInfoForm()
        }

        val noAd: NoAd = if (json.has(FIELD_NO_AD)) {
          NoAd.fromJson(json.getJSONObject(FIELD_NO_AD))
        } else {
          NoAd.getDefaultNoAd()
        }

        return UiComponents(noAd, userInfoForm)
      } catch (exception: JSONException) {
        HyprMXLog.e("Exception parsing UI Components")
        UiComponents(NoAd.getDefaultNoAd(), UserInfoForm.getDefaultUserInfoForm())
      }
    }

    private const val FIELD_USER_INFO_FORM = "user_info_form"
    private const val FIELD_NO_AD = "no_ad"
  }
}
