package com.hyprmx.android.sdk.api.data

import com.hyprmx.android.sdk.footer.Footer
import org.json.JSONObject

/**
 * This class represents the styling information for the 'Required Information' form
 * delivered to us by the 'ads available' response.
 *
 * This class is immutable.
 */
internal class UserInfoForm(
  val title: String,
  val title_color: String,
  val title_size: Int,
  val footer: Footer,
) {
  companion object {
    fun fromJson(json: JSONObject): UserInfoForm {
      return try {
        val title = json.optString(FIELD_TITLE, DEFAULT_TITLE)
        val titleColor = json.optString(FIELD_TITLE_COLOR, DEFAULT_TITLE_COLOR)
        val titleSize = json.optInt(FIELD_TITLE_SIZE, DEFAULT_TITLE_SIZE)

        val footer = Footer.fromJson(json.optJSONObject(Footer.FIELD_FOOTER))

        UserInfoForm(title, titleColor, titleSize, footer)
      } catch (exception: Exception) {
        getDefaultUserInfoForm()
      }
    }

    fun getDefaultUserInfoForm(): UserInfoForm {
      return UserInfoForm(
        DEFAULT_TITLE,
        DEFAULT_TITLE_COLOR,
        DEFAULT_TITLE_SIZE,
        footer = Footer.NAV_ONLY_FOOTER,
      )
    }

    private const val FIELD_TITLE = "title"
    private const val FIELD_TITLE_COLOR = "title_color"
    private const val FIELD_TITLE_SIZE = "title_size"

    private const val DEFAULT_TITLE = ""
    private const val DEFAULT_TITLE_COLOR = "FFFFFF"
    private const val DEFAULT_TITLE_SIZE = 16
  }
}
