package com.hyprmx.android.sdk.banner

import androidx.annotation.Keep
import com.hyprmx.android.sdk.placement.HyprMXLoadAdListener

/**
 * Public banner API
 */
@Keep
interface HyprMXBannerAd {
  var listener: HyprMXBannerListener?
  var placementName: String
  var adSize: HyprMXBannerSize?
  suspend fun loadAd(): Boolean
  fun loadAd(listener: HyprMXLoadAdListener)
  fun loadAd(onResult: (isAdAvailable: Boolean) -> Unit) {
    loadAd(object : HyprMXLoadAdListener {
      override fun onAdLoaded(isAdAvailable: Boolean) {
        onResult(isAdAvailable)
      }
    })
  }
  suspend fun loadAd(bidResponse: String): Boolean
  fun loadAd(bidResponse: String, listener: HyprMXLoadAdListener)
  fun loadAd(bidResponse: String, onResult: (isAdAvailable: Boolean) -> Unit) {
    loadAd(
      bidResponse,
      object : HyprMXLoadAdListener {
        override fun onAdLoaded(isAdAvailable: Boolean) {
          onResult(isAdAvailable)
        }
      },
    )
  }
  fun destroy()
}
