package com.hyprmx.android.sdk.banner

import androidx.annotation.Keep
import com.hyprmx.android.sdk.presentation.ArgumentKey.CONTAINER_HEIGHT
import com.hyprmx.android.sdk.presentation.ArgumentKey.CONTAINER_WIDTH

@Keep
sealed class HyprMXBannerSize(val width: Int, val height: Int) {
  @Keep
  object HyprMXAdSizeShort : HyprMXBannerSize(300, 50)

  @Keep
  object HyprMXAdSizeBanner : HyprMXBannerSize(320, 50)

  @Keep
  object HyprMXAdSizeMediumRectangle : HyprMXBannerSize(300, 250)

  @Keep
  object HyprMXAdSizeLeaderboard : HyprMXBannerSize(728, 90)

  @Keep
  object HyprMXAdSizeSkyScraper : HyprMXBannerSize(160, 600)

  @Keep
  class HyprMXAdSizeCustom(width: Int, height: Int) : HyprMXBannerSize(width, height)

  override fun toString(): String {
    return "${javaClass.simpleName} (width = $width, height = $height)"
  }

  internal fun toMap(): Map<String, Number> {
    return mapOf(CONTAINER_WIDTH to width, CONTAINER_HEIGHT to height)
  }
}
