package com.hyprmx.android.sdk.consent

import com.hyprmx.android.sdk.annotation.RetainMethodSignature
import com.hyprmx.android.sdk.core.js.JSEngine
import kotlinx.coroutines.CoroutineName
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.plus

/**
 * This class allows the javascript to grab given consent.
 */
internal class ConsentController(
  private val jsEngine: JSEngine,
  override var givenConsent: ConsentStatus,
  val scope: CoroutineScope,
) :
  ConsentControllerIf,
  ConsentControllerIf.ConsentJSListener,
  CoroutineScope by scope + CoroutineName("ConsentController") {

  companion object {
    const val TAG = "HYPRConsentController"
    const val NATIVE_CONTROLLER = "HYPRNativeConsentController"
    const val JSCONTROLLER = "HYPRConsentController"
  }

  init {
    jsEngine.addJavascriptInterface(this, NATIVE_CONTROLLER)
  }

  override fun setConsent(givenConsent: ConsentStatus) {
    this.givenConsent = givenConsent
    jsEngine.evaluate("$JSCONTROLLER.consentStatusChanged(${givenConsent.consent})")
  }

  @RetainMethodSignature
  override fun getConsentStatus(): Int {
    return this.givenConsent.consent
  }
}
