package com.hyprmx.android.sdk.footer

import android.graphics.Bitmap
import androidx.annotation.Keep
import com.hyprmx.android.sdk.mvp.BasePresenter
import com.hyprmx.android.sdk.mvp.BaseView

/**
 * The contract for the footer.  This defines the relationship
 * between the view, presenter and controlling activity
 */
@Keep
internal interface FooterContract {

  @Keep
  interface View : BaseView<Presenter> {
    fun setVisible(visible: Boolean)
    fun setBackgroundColor(color: Int)
    fun setMinimumHeight(minHeight: Int)
    fun enableNavigation(enable: Boolean)
    fun enableForwardNavigation(enable: Boolean)
    fun enableBackNavigation(enable: Boolean)
    fun setText(text: String)
    fun setIcon1(image: Bitmap, width: Int, height: Int)
    fun setIcon2(image: Bitmap, width: Int, height: Int)
    fun isContextInvalid(): Boolean
  }

  @Keep
  interface Presenter : BasePresenter {
    fun didTapForward()
    fun didTapBack()
    fun didTapURL(url: String)
    fun didTapIcon(index: Int)
    fun setVisible(visible: Boolean)
    fun enableForwardNavigation(enable: Boolean)
    fun enableBackwardNavigation(enable: Boolean)
  }

  @Keep
  interface NavigationPresenter {
    fun didTapForward()
    fun didTapBack()
    fun didTapIcon(index: Int)
  }

  @Keep
  interface URLPresenter {
    fun didTapURL(url: String)
  }
}
