package com.hyprmx.android.sdk.footer

import org.json.JSONException
import org.json.JSONObject
import java.io.Serializable

internal class Image(val portraitUrl: String, val height: Int, val width: Int, val link: String) :
  Serializable {
  companion object {
    private const val FIELD_PORTRAITURL = "portrait_url"
    private const val FIELD_HEIGHT = "height"
    private const val FIELD_WIDTH = "width"
    private const val FIELD_LINKURL = "link"
    const val FIELD_IMAGE = "image"

    private const val DEFAULT_HEIGHT = 15
    private const val DEFAULT_WIDTH = 15

    @Throws(JSONException::class)
    fun fromJSON(jsonObject: JSONObject?): Image? {
      return jsonObject?.let { imageJSON ->
        Image(
          imageJSON.getString(FIELD_PORTRAITURL),
          imageJSON.optInt(FIELD_HEIGHT, DEFAULT_HEIGHT),
          imageJSON.optInt(FIELD_WIDTH, DEFAULT_WIDTH),
          imageJSON.optString(FIELD_LINKURL),
        )
      }
    }
  }
}
