package com.hyprmx.android.sdk.graphics

import android.content.Context
import android.graphics.Color
import android.graphics.drawable.GradientDrawable
import androidx.appcompat.widget.AppCompatImageView
import com.hyprmx.android.R
import com.hyprmx.android.sdk.utility.convertDpToPixel

/**
 * Displays the scaled close button depending on the density of the device screen.
 */
internal class HyprMXCloseButton @JvmOverloads constructor(
  context: Context,
  withBackground: Boolean = false,
) : AppCompatImageView(context) {

  init {
    id = R.id.hyprmx_video_controller_close_button
    tag = javaClass.simpleName
    setPadding(
      8.convertDpToPixel(context),
      8.convertDpToPixel(context),
      8.convertDpToPixel(context),
      8.convertDpToPixel(context),
    )
    scaleType = ScaleType.CENTER_INSIDE
    adjustViewBounds = true
    setImageResource(R.drawable.hyprmx_close_button)

    if (withBackground) {
      val shape = GradientDrawable()
      shape.shape = GradientDrawable.OVAL
      shape.setColor(Color.DKGRAY)
      shape.alpha = 180
      background = shape
    }
  }
}
