package com.hyprmx.android.sdk.header

import com.hyprmx.android.sdk.utility.getStringOrNull
import org.json.JSONException
import org.json.JSONObject
import java.io.Serializable

/**
 * The webtraffic header model
 */
internal data class WebTrafficHeader(
  val bgColor: String,
  val titleText: String,
  val nextButtonText: String,
  val finishButtonText: String,
  val countDownText: String,
  val finishButtonMinWidth: Int,
  val finishButtonMinHeight: Int,
  val nextButtonMinWidth: Int,
  val nextButtonMinHeight: Int,
  val nextButtonColor: String,
  val finishButtonColor: String,
  val pageIndicatorColor: String,
  val pageIndicatorSelectedColor: String,
  val minimumHeaderHeight: Int,
  val closeButtonColor: String,
  val chevronColor: String,
  val spinnerColor: String?,
) : Serializable {
  companion object {
    private const val FIELD_BACKGROUND_COLOR = "header_background_color"
    private const val FIELD_TITLE_TEXT = "title_text"
    private const val FIELD_NEXT_BUTTON_TEXT = "next_button_text"
    private const val FIELD_FINISH_BUTTON_TEXT = "finish_button_text"
    private const val FIELD_COUNTDOWN_TEXT = "countdown_text"
    private const val FIELD_FINISH_BUTTON_MIN_SIZE = "finish_button_minimum_size"
    private const val FIELD_NEXT_BUTTON_MIN_SIZE = "next_button_minimum_size"
    private const val FIELD_NEXT_BUTTON_COLOR = "next_button_color"
    private const val FIELD_FINISH_BUTTON_COLOR = "finish_button_color"
    private const val FIELD_PAGE_INDICATOR_COLOR = "page_indicator_color"
    private const val FIELD_PAGE_INDICATOR_SELECTED_COLOR = "page_indicator_color_selected"
    private const val FIELD_MINIMUM_HEADER_HEIGHT = "minimum_header_height"
    private const val FIELD_CLOSE_BUTTON_COLOR = "close_button_color"
    private const val FIELD_CHEVRON_COLOR = "chevron_color"
    private const val FIELD_SPINNER_COLOR = "spinner_tint_color"

    private const val FIELD_HEIGHT = "height"
    private const val FIELD_WIDTH = "width"

    /**
     * Gets the parsed web-traffic header.  If none provided, then it uses a default header.
     */
    @Throws(JSONException::class)
    fun fromJson(jsonObject: JSONObject?): WebTrafficHeader {
      return jsonObject?.let { headerJSON ->
        WebTrafficHeader(
          headerJSON.getString(FIELD_BACKGROUND_COLOR),
          headerJSON.getString(FIELD_TITLE_TEXT),
          headerJSON.getString(FIELD_NEXT_BUTTON_TEXT),
          headerJSON.getString(FIELD_FINISH_BUTTON_TEXT),
          headerJSON.getString(FIELD_COUNTDOWN_TEXT),
          headerJSON.getJSONObject(FIELD_FINISH_BUTTON_MIN_SIZE).getInt(FIELD_WIDTH),
          headerJSON.getJSONObject(FIELD_FINISH_BUTTON_MIN_SIZE).getInt(FIELD_HEIGHT),
          headerJSON.getJSONObject(FIELD_NEXT_BUTTON_MIN_SIZE).getInt(FIELD_WIDTH),
          headerJSON.getJSONObject(FIELD_NEXT_BUTTON_MIN_SIZE).getInt(FIELD_HEIGHT),
          headerJSON.getString(FIELD_NEXT_BUTTON_COLOR),
          headerJSON.getString(FIELD_FINISH_BUTTON_COLOR),
          headerJSON.getString(FIELD_PAGE_INDICATOR_COLOR),
          headerJSON.getString(FIELD_PAGE_INDICATOR_SELECTED_COLOR),
          headerJSON.getInt(FIELD_MINIMUM_HEADER_HEIGHT),
          headerJSON.getString(FIELD_CLOSE_BUTTON_COLOR),
          headerJSON.getString(FIELD_CHEVRON_COLOR),
          headerJSON.getStringOrNull(FIELD_SPINNER_COLOR),
        )
      } ?: WebTrafficHeader(
        "D9D9D9",
        "<font color='#3a3a3a'>Some websites</font>",
        "<font color='#ffffff'>Next</font>",
        "<font color='#ffffff'>Finish</font>",
        "<font color='#5D5D5D'><b>%s</b></font>",
        60, 20, 60, 20,
        "527FBD",
        "527FBD",
        "AAAAAA",
        "527FBD",
        55,
        "5D5D5D",
        "ffffff",
        "737373",
      )
    }
  }
}
