package com.hyprmx.android.sdk.header

import com.hyprmx.android.sdk.mvp.BasePresenter
import com.hyprmx.android.sdk.mvp.BaseView

/**
 * The contract for the header.  This defines the relationship
 * between the view, webTrafficPresenter and controlling activity
 */
internal interface WebTrafficHeaderContract {
  interface View : BaseView<Presenter> {
    fun setTitleText(text: String)
    fun setBackgroundColor(color: Int)
    fun setPageCount(count: Int, color: Int)
    fun hidePageCount()
    fun setPageCountState(index: Int, color: Int)
    fun showCloseButton(color: Int)
    fun hideCloseButton()
    fun showNextButton(text: String, color: Int, chevronColor: Int, minHeight: Int, minWidth: Int)
    fun hideNextButton()
    fun showFinishButton(text: String, color: Int, chevronColor: Int, minHeight: Int, minWidth: Int)
    fun hideFinishButton()
    fun setCountDown(countDown: String)
    fun hideCountDown()
    fun showProgressSpinner()
    fun showProgressSpinner(color: Int)
    fun hideProgressSpinner()
    fun setMinHeight(minHeight: Int)
    fun disableCloseButton()
    fun enableCloseButton()
  }

  interface Presenter : BasePresenter {
    fun didTapNext()
    fun didTapFinish()
    fun didTapClose()
    fun showNextButton()
    fun showFinishButton()
    fun hideFinishButton()
    fun showCountDown(time: String)
    fun showProgressSpinner()
    fun setPageVisited(pageNumber: Int)
    fun showWithTitleAndPageCount(pageCount: Int)
    fun showCloseButtonOnly()
    fun backgrounded()
    fun foregrounded()
  }

  interface NavigationPresenter {
    fun didTapFinish()
    fun didTapNext()
    fun didTapClose()
  }
}
