package com.hyprmx.android.sdk.initialization

import com.hyprmx.android.sdk.annotation.RetainMethodSignature

/**
 * The interface used to interact with the the controller
 */
internal interface InitializationControllerIf {

  suspend fun initialize(
    initializationDelegator: InitializationDelegator,
  ): InitializationResult

  suspend fun javascriptUpgradeFailed(errorMsg: String): InitializationResult

  interface InitializationNativeInterface {

    @RetainMethodSignature
    fun updateJavascript(url: String, version: Int, timeout: Int)

    @RetainMethodSignature
    fun initializationSuccessWithPlacements(placementsJsonString: String, jsVersion: Int)

    @RetainMethodSignature
    fun initializationFailed(error: String)

    @RetainMethodSignature
    fun setSharingEndpoint(sharingEndpoint: String)

    @RetainMethodSignature
    fun initializeOMSDK(omSdkUrl: String, omPartnerName: String, omApiVersion: String)

    /**
     * Overrides the logging.  Enabling this will always print the logs to logcat.
     * Note, setting this is persisted and reused on subsequent launches.
     */
    @RetainMethodSignature
    fun setEnableAllLogs(enabled: Boolean)
  }
}

sealed class InitializationResult {
  class Success(val placementJSON: String) : InitializationResult()
  class Failed(val error: String) : InitializationResult()
  class UpdateJavascript(val coreJSURL: String, val version: Int, val timeout: Int) :
    InitializationResult()

  object RollbackJavascript : InitializationResult()
}
