package com.hyprmx.android.sdk.jsAlertDialog

import android.content.Context
import com.hyprmx.android.sdk.api.data.PresentDialog
import com.hyprmx.android.sdk.mvp.BasePresenter
import com.hyprmx.android.sdk.mvp.BaseView

internal interface JSAlertDialogContract {

  interface View : BaseView<Presenter> {

    fun showDialog(context: Context, title: String?, message: String, buttonTexts: List<String>)

    fun dismissDialog()
  }

  interface Presenter : BasePresenter {

    fun createAndShowDialog(context: Context, presentDialog: PresentDialog)

    fun dismissDialog()

    fun onButtonPressed(name: String)

    fun onDialogDisplayed()

    fun onDialogDismissed()
  }

  interface WebViewPresenter {

    fun executeJS(script: String)
  }

  interface AdDialogPresenter {

    fun onDialogDisplayed()

    fun onDialogDismissed()
  }
}
