package com.hyprmx.android.sdk.model

import org.json.JSONArray
import org.json.JSONObject

/**
 * Merge the two JSON objects together
 */
fun JSONObject.addAll(jsonToAdd: JSONObject?) {
  if (jsonToAdd != null && jsonToAdd.length() > 0) {
    jsonToAdd.keys().forEach { put(it, jsonToAdd.get(it)) }
  }
}

/**
 * Optionally adds the item to the array if it exists
 */
fun JSONArray.optPut(jsonToAdd: JSONObject?) {
  jsonToAdd?.let { this.put(jsonToAdd) }
}
