package com.hyprmx.android.sdk.mvp

import com.hyprmx.android.sdk.presentation.ArgumentKey
import com.hyprmx.android.sdk.presentation.PresentationEventPublisher
import com.hyprmx.android.sdk.presentation.PublishingEvent
import kotlinx.coroutines.CoroutineScope

internal interface LifecycleEventHandler {
  fun onLifecycleEvent(event: String)
}

internal class LifecycleEventAdapter(publisher: PresentationEventPublisher, scope: CoroutineScope) : LifecycleEventHandler, PresentationEventPublisher by publisher, CoroutineScope by scope {
  override fun onLifecycleEvent(event: String) {
    publishEvent(PublishingEvent.ON_LIFECYCLE_EVENT, mapOf(ArgumentKey.EVENT to event))
  }
}

object LifecycleEvent {
  const val onAttachedToWindow = "onAttachedToWindow"
  const val onDetachedFromWindow = "onDetachedFromWindow"

  const val ON_CREATE = "onCreate"
  const val ON_START = "onStart"
  const val ON_RESUME = "onResume"
  const val ON_PAUSE = "onPause"
  const val ON_STOP = "onStop"
  const val ON_DESTROY = "onDestroy"
}
