package com.hyprmx.android.sdk.om

import android.webkit.WebView
import com.iab.omid.library.jungroup.adsession.AdEvents
import com.iab.omid.library.jungroup.adsession.AdSession
import com.iab.omid.library.jungroup.adsession.AdSessionConfiguration
import com.iab.omid.library.jungroup.adsession.AdSessionContext
import com.iab.omid.library.jungroup.adsession.CreativeType
import com.iab.omid.library.jungroup.adsession.ImpressionType
import com.iab.omid.library.jungroup.adsession.Owner
import com.iab.omid.library.jungroup.adsession.Partner

internal class OpenMeasurementBannerSession(private val partner: Partner) : BannerOMSession {
  private var adSession: AdSession? = null
  private var adEvents: AdEvents? = null

  override fun startOMSession(webView: WebView, contentUrl: String, customReferenceData: String) {
    val context = AdSessionContext.createHtmlAdSessionContext(
      partner,
      webView,
      contentUrl,
      customReferenceData,
    )

    val adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration(
      CreativeType.HTML_DISPLAY,
      ImpressionType.ONE_PIXEL,
      Owner.NATIVE,
      Owner.NONE,
      false,
    )

    adSession = AdSession.createAdSession(adSessionConfiguration, context)

    adSession?.registerAdView(webView)

    // Start the session
    adSession?.start()

    adEvents = AdEvents.createAdEvents(adSession)
    adEvents?.impressionOccurred()
    adEvents?.loaded()
  }

  override fun finishOMSession() {
    adSession?.finish()
    adSession = null
  }
}

interface BannerOMSession {
  fun startOMSession(webView: WebView, contentUrl: String = "", customReferenceData: String = "")
  fun finishOMSession()
}
