package com.hyprmx.android.sdk.overlay

import android.content.Context
import com.hyprmx.android.sdk.core.BasePresenter
import com.hyprmx.android.sdk.core.BaseView
import com.hyprmx.android.sdk.utility.PermissionRequest
import com.hyprmx.android.sdk.utility.PermissionResponse

internal interface HyprMXBrowserContract {
  interface View : BaseView, HyprMXOverlay, PermissionRequest, ImageCapture {
    fun navigateBackEnabled(enabled: Boolean)
    fun navigateForwardEnabled(enabled: Boolean)
    fun closeButtonEnabled(enabled: Boolean)
    fun setTitleText(title: String)
    fun finishActivity()
    fun captureImage()

    /**
     * Removes the presenters in case of an SDK ReInit Event
     * allowing the activity to be safely destroyed
     */
    fun cleanupPresenters()
  }

  interface Presenter : BasePresenter<View>, PermissionResponse {
    var launchContext: Context?
    var stateListener: PresentationStateListener?
    fun initializeViewState()
    fun onBrowserReady()
    fun onNavigateBackPressed()
    fun onNavigateForwardPressed()
    fun onCloseClicked()
    fun onBackPressed()
    fun onSharePressed()
  }
}
