package com.hyprmx.android.sdk.overlay

import android.app.Activity
import android.content.Context
import android.content.Intent
import com.hyprmx.android.sdk.core.ImageCaptureInterface
import com.hyprmx.android.sdk.utility.HyprMXLog
import com.hyprmx.android.sdk.utility.galleryAddPic

internal interface ImageCapture {
  fun dispatchImageCaptureIntent(activity: Activity)
  suspend fun processActivityResult(
    context: Context,
    requestCode: Int,
    resultCode: Int,
    data: Intent?,
    imageCapture: ImageCaptureInterface,
  )
}

internal class ImageCapturer : ImageCapture {
  private var currentPhotoPath: String? = null
  private var fileProviderPath: String? = null

  override fun dispatchImageCaptureIntent(activity: Activity) {
    val contentSelectionIntent = Intent(Intent.ACTION_GET_CONTENT)
    contentSelectionIntent.addCategory(Intent.CATEGORY_OPENABLE)
    contentSelectionIntent.type = "image/*"

    val chooserIntent = Intent(Intent.ACTION_CHOOSER)
    chooserIntent.putExtra(Intent.EXTRA_INTENT, contentSelectionIntent)
    chooserIntent.putExtra(Intent.EXTRA_TITLE, "Image Chooser")

    activity.startActivityForResult(chooserIntent, REQUEST_IMAGE_CAPTURE)
  }

  override suspend fun processActivityResult(
    context: Context,
    requestCode: Int,
    resultCode: Int,
    data: Intent?,
    imageCapture: ImageCaptureInterface,
  ) {
    if (requestCode != REQUEST_IMAGE_CAPTURE) {
      return
    }
    HyprMXLog.d("processActivityResult REQUEST_IMAGE_CAPTURE returned with result code $resultCode")

    if (resultCode != Activity.RESULT_OK) {
      // Notify the webview to clean up the file chooser
      imageCapture.imageCaptured(null)
      return
    }

    try {
      val path = if (data == null || data.dataString == null) {
        // If there is no data, then a photo was taken
        currentPhotoPath?.let {
          galleryAddPic(context, it)
        }
        fileProviderPath
      } else {
        data.dataString
      }

      currentPhotoPath = null
      fileProviderPath = null

      imageCapture.imageCaptured(path)
    } catch (ex: Exception) {
      HyprMXLog.e("Problem processing activity result.", ex)
      // Notify the webview to clean up the file chooser
      imageCapture.imageCaptured(null)
    }
  }

  companion object {
    const val REQUEST_IMAGE_CAPTURE = 1
  }
}
