package com.hyprmx.android.sdk.placement

import androidx.annotation.Keep
import com.hyprmx.android.sdk.core.HyprMXErrors

@Keep
interface HyprMXShowListener {

  /**
   * The ad has started showing
   *
   * @param placement The placement being shown
   */
  fun onAdStarted(placement: Placement)

  /**
   * The ad has finished showing
   *
   * @param placement The placement being show
   * @param finished  true if the ad finished, false otherwise
   */
  fun onAdClosed(placement: Placement, finished: Boolean)

  /**
   * There was an error with the placement during presentation.
   *
   * @param placement   The placement with the error
   * @param hyprMXError The error that occurred
   * @see HyprMXErrors
   */
  fun onAdDisplayError(placement: Placement, hyprMXError: HyprMXErrors)

  /**
   * The ad has had an impression
   * @param placement The placement that had the impression
   */
  fun onAdImpression(placement: Placement)
}
