package com.hyprmx.android.sdk.placement

import androidx.annotation.Keep

/**
 * Types of PlacementImpl
 */
@Keep
enum class PlacementType {

  REWARDED,
  INTERSTITIAL,
  BANNER,
  INVALID,
  ;

  companion object {

    fun fromString(type: String): PlacementType {
      for (placementType in PlacementType.values()) {
        val string = placementType.name
        if (string.equals(type, ignoreCase = true)) {
          return placementType
        }
      }
      throw IllegalArgumentException("Invalid PlacementImpl Type.")
    }
  }
}
