package com.hyprmx.android.sdk.preferences

/**
 * Interface to the shared preferences
 */
interface PreferencesControllerIf {

  /**
   *  Gets the value for the key.  Returns a JSON formatted string in the following form:
   *
   *  { "value":"" }
   *
   *  @return The boolean if it exists, null otherwise
   */
  fun getSharedValue(key: String): String

  /**
   *  Request to monitor the key in the preferences
   *  for changes
   *
   *  Note:  Only 1 listener per key
   *
   *  @listener The object name of the JS Component to call back to
   *  @key The key to monitor
   */
  fun monitorSharedValue(listener: String, key: String)

  /**
   * Stop listening for shared value changes
   */
  fun stopMonitoring()
}
