package com.hyprmx.android.sdk.preload

import com.hyprmx.android.sdk.annotation.RetainMethodSignature
import com.hyprmx.android.sdk.webview.HyprMXWebView

/**
 * Preload interface incoming from shared coded
 */
interface PreloadNativeInterface {
  @RetainMethodSignature
  fun preloadUIImage(
    url: String,
    height: Int,
    width: Int,
    scale: Float?,
    tiled: Boolean?,
    x: Int?,
    y: Int?,
  )

  @RetainMethodSignature
  fun preloadPortraitImage(portraitUrl: String, height: Int, width: Int, fillScreenWidth: Boolean?)

  @RetainMethodSignature
  fun storeInstance(viewModelIdentifier: String)

  @RetainMethodSignature
  fun removeInstance(viewModelIdentifier: String)
}

internal interface PreloadedWebView {
  fun getPreloadedWebView(viewModelIdentifier: String): HyprMXWebView?
}
