package com.hyprmx.android.sdk.tracking

/**
 * Tracking interface.
 */
internal interface VideoTracking {
  /**
   * Progress event occurred at this time
   * @param time Time in seconds
   */
  suspend fun onProgress(time: Long) {}

  /**
   * The video has started
   */
  suspend fun onStart() {}

  /**
   * The video has reached 25% of playback
   */
  suspend fun onFirstQuartile() {}

  /**
   * The video has reached 50% of playback
   */
  suspend fun onMidPoint() {}

  /**
   * The video has reached 75% of playback
   */
  suspend fun onThirdQuartile() {}

  /**
   * The video has completed
   */
  suspend fun onComplete() {}

  /**
   * The video has been setup
   */
  suspend fun onImpression() {}

  /**
   * The video has been clicked on and transitioned
   */
  suspend fun onClick() {}

  /**
   * This event indicates that an individual creative portion of the ad was viewed.
   */
  suspend fun onView() {}

  /**
   * The video has closed
   */
  suspend fun onClose() {}

  /**
   * The video has paused
   */
  suspend fun onPause() {}

  /**
   * The video has resumed
   */
  suspend fun onResume() {}

  /**
   * The video was skipped
   */
  suspend fun onSkip() {}

  /**
   * The video is viewable
   */
  suspend fun onViewable() {}

  /**
   * The video could not be played
   */
  suspend fun onNonViewable() {}

  /**
   * Notifies video volume changed
   */
  suspend fun onVolumeChange(videoPlayerVolume: Float) {}
}
