package com.hyprmx.android.sdk.utility

import android.text.Selection
import android.text.Spannable
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.URLSpan
import android.view.MotionEvent
import android.widget.TextView

/**
 * Extends the LinkMovementMethod class to capture click events and returns the call via the
 * supplied URL handler
 *
 * @param urlHandler The url handler to callback to
 */
internal class CustomLinkMovement(private val urlHandler: URLHandler) : LinkMovementMethod() {
  override fun onTouchEvent(
    widget: TextView,
    buffer: Spannable,
    event: MotionEvent,
  ): Boolean {
    val action = event.action

    if (action == MotionEvent.ACTION_UP || action == MotionEvent.ACTION_DOWN) {
      var x = event.x.toInt()
      var y = event.y.toInt()

      x -= widget.totalPaddingLeft
      y -= widget.totalPaddingTop

      x += widget.scrollX
      y += widget.scrollY

      val layout = widget.layout
      val line = layout.getLineForVertical(y)
      val off = layout.getOffsetForHorizontal(line, x.toFloat())

      val links = buffer.getSpans(off, off, ClickableSpan::class.java)

      if (links.isNotEmpty()) {
        if (action == MotionEvent.ACTION_UP) {
          if (links[0] is URLSpan) {
            urlHandler.onLinkedClicked((links[0] as URLSpan).url)
          }
        } else if (action == MotionEvent.ACTION_DOWN) {
          Selection.setSelection(
            buffer,
            buffer.getSpanStart(links[0]),
            buffer.getSpanEnd(links[0]),
          )
        }
        return true
      } else {
        Selection.removeSelection(buffer)
      }
    }

    return super.onTouchEvent(widget, buffer, event)
  }
}

/**
 *  Handles URL clicks events and passes them on
 */
interface URLHandler {
  fun onLinkedClicked(url: String)
}
