package com.hyprmx.android.sdk.utility

/**
 * Provide different type of client error types.
 */
enum class HyprMXErrorType(private val errorType: String) {

  HYPRErrorTypeFailureToLoad("Could not load from the API"),
  HYPRErrorTypeVastPlayerError("Error occurred while playing a VAST video"),
  HYPRErrorTypeSDKInternalError("SDK Internal Error"),
  HYPRErrorTypeJSONParsingFailure("There was an error parsing the JSON object"),
  HYPRErrorTypeShouldNeverHappen("This should NEVER happen."),
  HYPRErrorAdDisplay("Error while viewing an offer."),
  HYPRErrorExitingAd("Ad was exited unintentionally."),
  HYPRErrorTypeCacheJournal("There was an error with the cache journal"),
  HYPRErrorInvalidEndpoint("Invalid endpoint send from server."),
  ;

  override fun toString(): String {
    return errorType
  }
}
