package com.hyprmx.android.sdk.utility

import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.PERMISSION_RESPONSE_ARG_GRANTED
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.PERMISSION_RESPONSE_ARG_PERMISSION
import org.json.JSONObject

internal interface PermissionResponse {
  fun onPermissionResponse(permissionResults: List<PermissionResult>, requestCode: Int)
}

internal interface PermissionRequest {
  fun requestPermission(permission: Array<String>, requestCode: Int)
}

data class PermissionResult(val permission: String, val granted: Boolean) {
  fun toJSON(): JSONObject {
    return JSONObject().put(
      PERMISSION_RESPONSE_ARG_PERMISSION,
      permission,
    ).put(PERMISSION_RESPONSE_ARG_GRANTED, granted)
  }
}
