package com.hyprmx.android.sdk.utility

/**
 * Generic Success/Failure result with value
 */
internal sealed class Result<out T> {
  /**
   * This will be returned on the result of a successful request.
   * @param value The value here is the expected object of type T to be returned on success.
   */
  class Success<T>(val value: T) : Result<T>()

  /**
   * This will be returned on the result of an failure for the request
   * @param message The error message describing the failure
   * @param code An error code to help describe/categorize/locate the error.
   * @param throwable If the failure was the result of an exception, you can pass the exception back for evaluation later.
   */
  class Failure(val message: String, val code: Int, val throwable: Throwable? = null) :
    Result<Nothing>() {
    init {
      HyprMXLog.d("Failure( code = $code, message = $message )")
    }
  }
}
