@file:Suppress("FunctionName")

package com.hyprmx.android.sdk.webview

import android.annotation.SuppressLint
import android.content.Context
import android.content.pm.PackageInfo
import androidx.webkit.WebViewCompat

internal interface SystemWebViewAvailability {
  fun hasSystemWebViewAvailable(context: Context): Boolean
}

internal class DefaultSystemWebViewAvailability : SystemWebViewAvailability {
  override fun hasSystemWebViewAvailable(context: Context): Boolean {
    return getCurrentWebViewPackageInfo(context) != null
  }

  @SuppressLint("PrivateApi", "WebViewApiAvailability")
  private fun getCurrentWebViewPackageInfo(context: Context): PackageInfo? {
    return WebViewCompat.getCurrentWebViewPackage(context)
  }
}

internal fun SystemWebViewAvailability() = DefaultSystemWebViewAvailability()
