/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jlyrics;

import com.jagrosh.jlyrics.Lyrics;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.safety.Whitelist;

public class LyricsClient {
    private final Config config = ConfigFactory.load();
    private final HashMap<String, Lyrics> cache = new HashMap();
    private final Document.OutputSettings noPrettyPrint = new Document.OutputSettings().prettyPrint(false);
    private final Whitelist newlineWhitelist = Whitelist.none().addTags(new String[]{"br", "p"});
    private final Executor executor;
    private final String defaultSource;
    private final String userAgent;
    private final int timeout;

    public LyricsClient() {
        this(null, null);
    }

    public LyricsClient(String defaultSource) {
        this(defaultSource, null);
    }

    public LyricsClient(Executor executor) {
        this(null, executor);
    }

    public LyricsClient(String defaultSource, Executor executor) {
        this.defaultSource = defaultSource == null ? this.config.getString("lyrics.default") : defaultSource;
        this.userAgent = this.config.getString("lyrics.user-agent");
        this.timeout = this.config.getInt("lyrics.timeout");
        this.executor = executor == null ? Executors.newCachedThreadPool() : executor;
    }

    public CompletableFuture<Lyrics> getLyrics(String search) {
        return this.getLyrics(search, this.defaultSource);
    }

    public CompletableFuture<Lyrics> getLyrics(String search, String source) {
        String cacheKey = source + "||" + search;
        if (this.cache.containsKey(cacheKey)) {
            return CompletableFuture.completedFuture(this.cache.get(cacheKey));
        }
        try {
            String searchUrl = String.format(this.config.getString("lyrics." + source + ".search.url"), search);
            boolean jsonSearch = this.config.getBoolean("lyrics." + source + ".search.json");
            String select = this.config.getString("lyrics." + source + ".search.select");
            String titleSelector = this.config.getString("lyrics." + source + ".parse.title");
            String authorSelector = this.config.getString("lyrics." + source + ".parse.author");
            String contentSelector = this.config.getString("lyrics." + source + ".parse.content");
            return CompletableFuture.supplyAsync(() -> {
                try {
                    Document doc;
                    Connection connection = Jsoup.connect((String)searchUrl).userAgent(this.userAgent).timeout(this.timeout);
                    if (jsonSearch) {
                        String body = connection.ignoreContentType(true).execute().body();
                        JSONObject json = new JSONObject(body);
                        doc = Jsoup.parse((String)XML.toString((Object)json));
                    } else {
                        doc = connection.get();
                    }
                    Element urlElement = doc.selectFirst(select);
                    String url = jsonSearch ? urlElement.text() : urlElement.attr("abs:href");
                    if (url == null || url.isEmpty()) {
                        return null;
                    }
                    doc = Jsoup.connect((String)url).userAgent(this.userAgent).timeout(this.timeout).get();
                    Lyrics lyrics = new Lyrics(doc.selectFirst(titleSelector).ownText(), doc.selectFirst(authorSelector).ownText(), this.cleanWithNewlines(doc.selectFirst(contentSelector)), url, source);
                    this.cache.put(cacheKey, lyrics);
                    return lyrics;
                }
                catch (IOException | NullPointerException | JSONException ex) {
                    return null;
                }
            }, this.executor);
        }
        catch (ConfigException ex) {
            throw new IllegalArgumentException(String.format("Source '%s' does not exist or is not configured correctly", source));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private String cleanWithNewlines(Element element) {
        return Jsoup.clean((String)Jsoup.clean((String)element.html(), (Whitelist)this.newlineWhitelist), (String)"", (Whitelist)Whitelist.none(), (Document.OutputSettings)this.noPrettyPrint);
    }
}

