/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.command;

import com.jagrosh.jdautilities.command.CommandEvent;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;

public abstract class Command {
    protected String name = "null";
    protected String help = "no help available";
    protected Category category = null;
    protected String arguments = null;
    protected boolean guildOnly = true;
    protected String requiredRole = null;
    protected boolean ownerCommand = false;
    protected int cooldown = 0;
    protected Permission[] userPermissions = new Permission[0];
    protected Permission[] botPermissions = new Permission[0];
    protected String[] aliases = new String[0];
    protected Command[] children = new Command[0];
    protected BiConsumer<CommandEvent, Command> helpBiConsumer = null;
    protected boolean usesTopicTags = true;
    protected boolean hidden = false;
    protected CooldownScope cooldownScope = CooldownScope.USER;
    private static final String BOT_PERM = "%s I need the %s permission in this %s!";
    private static final String USER_PERM = "%s You must have the %s permission in this %s to use that!";

    protected abstract void execute(CommandEvent var1);

    /*
     * WARNING - void declaration
     */
    public final void run(CommandEvent event) {
        if (!event.getArgs().isEmpty()) {
            void var5_10;
            String[] parts = Arrays.copyOf(event.getArgs().split("\\s+", 2), 2);
            if (this.helpBiConsumer != null && parts[0].equalsIgnoreCase(event.getClient().getHelpWord())) {
                this.helpBiConsumer.accept(event, this);
                return;
            }
            Command[] commandArray = this.children;
            int n = commandArray.length;
            boolean i = false;
            while (var5_10 < n) {
                Command cmd = commandArray[var5_10];
                if (cmd.isCommandFor(parts[0])) {
                    event.setArgs(parts[1] == null ? "" : parts[1]);
                    cmd.run(event);
                    return;
                }
                ++var5_10;
            }
        }
        if (this.ownerCommand && !event.isOwner()) {
            this.terminate(event, null);
            return;
        }
        if (this.category != null && !this.category.test(event)) {
            this.terminate(event, this.category.getFailureResponse());
            return;
        }
        if (event.isFromType(ChannelType.TEXT) && !this.isAllowed(event.getTextChannel())) {
            this.terminate(event, "That command cannot be used in this channel!");
            return;
        }
        if (this.requiredRole != null && (!event.isFromType(ChannelType.TEXT) || event.getMember().getRoles().stream().noneMatch(r -> r.getName().equalsIgnoreCase(this.requiredRole)))) {
            this.terminate(event, event.getClient().getError() + " You must have a role called `" + this.requiredRole + "` to use that!");
            return;
        }
        if (event.getChannelType() == ChannelType.TEXT) {
            for (String string : this.botPermissions) {
                if (string.isChannel()) {
                    if (string.name().startsWith("VOICE")) {
                        VoiceChannel vc = event.getMember().getVoiceState().getChannel();
                        if (vc == null) {
                            this.terminate(event, event.getClient().getError() + " You must be in a voice channel to use that!");
                            return;
                        }
                        if (event.getSelfMember().hasPermission((Channel)vc, new Permission[]{string})) continue;
                        this.terminate(event, String.format(BOT_PERM, event.getClient().getError(), string.getName(), "Voice Channel"));
                        return;
                    }
                    if (event.getSelfMember().hasPermission((Channel)event.getTextChannel(), new Permission[]{string})) continue;
                    this.terminate(event, String.format(BOT_PERM, event.getClient().getError(), string.getName(), "Channel"));
                    return;
                }
                if (event.getSelfMember().hasPermission(new Permission[]{string})) continue;
                this.terminate(event, String.format(BOT_PERM, event.getClient().getError(), string.getName(), "Guild"));
                return;
            }
            for (String string : this.userPermissions) {
                if (string.isChannel()) {
                    if (event.getMember().hasPermission((Channel)event.getTextChannel(), new Permission[]{string})) continue;
                    this.terminate(event, String.format(USER_PERM, event.getClient().getError(), string.getName(), "Channel"));
                    return;
                }
                if (event.getMember().hasPermission(new Permission[]{string})) continue;
                this.terminate(event, String.format(USER_PERM, event.getClient().getError(), string.getName(), "Guild"));
                return;
            }
        } else if (this.guildOnly) {
            this.terminate(event, event.getClient().getError() + " This command cannot be used in Direct messages");
            return;
        }
        if (this.cooldown > 0) {
            String key = this.getCooldownKey(event);
            int remaining = event.getClient().getRemainingCooldown(key);
            if (remaining > 0) {
                String error = this.getCooldownError(event, remaining);
                if (error != null) {
                    this.terminate(event, error);
                    return;
                }
            } else {
                event.getClient().applyCooldown(key, this.cooldown);
            }
        }
        try {
            this.execute(event);
        }
        catch (Throwable t) {
            if (event.getClient().getListener() != null) {
                event.getClient().getListener().onCommandException(event, this, t);
                return;
            }
            throw t;
        }
        if (event.getClient().getListener() != null) {
            event.getClient().getListener().onCompletedCommand(event, this);
        }
    }

    public boolean isCommandFor(String input) {
        if (this.name.equalsIgnoreCase(input)) {
            return true;
        }
        for (String alias : this.aliases) {
            if (!alias.equalsIgnoreCase(input)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowed(TextChannel channel) {
        String lowerCat;
        if (!this.usesTopicTags) {
            return true;
        }
        if (channel == null) {
            return true;
        }
        String topic = channel.getTopic();
        if (topic == null || topic.isEmpty()) {
            return true;
        }
        topic = topic.toLowerCase();
        String lowerName = this.name.toLowerCase();
        if (topic.contains("{" + lowerName + "}")) {
            return true;
        }
        if (topic.contains("{-" + lowerName + "}")) {
            return false;
        }
        String string = lowerCat = this.category == null ? null : this.category.getName().toLowerCase();
        if (lowerCat != null) {
            if (topic.contains("{" + lowerCat + "}")) {
                return true;
            }
            if (topic.contains("{-" + lowerCat + "}")) {
                return false;
            }
        }
        return !topic.contains("{-all}");
    }

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.help;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getArguments() {
        return this.arguments;
    }

    public boolean isGuildOnly() {
        return this.guildOnly;
    }

    public String getRequiredRole() {
        return this.requiredRole;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public Permission[] getUserPermissions() {
        return this.userPermissions;
    }

    public Permission[] getBotPermissions() {
        return this.botPermissions;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public Command[] getChildren() {
        return this.children;
    }

    public boolean isOwnerCommand() {
        return this.ownerCommand;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    private void terminate(CommandEvent event, String message) {
        if (message != null) {
            event.reply(message);
        }
        if (event.getClient().getListener() != null) {
            event.getClient().getListener().onTerminatedCommand(event, this);
        }
    }

    public String getCooldownKey(CommandEvent event) {
        switch (this.cooldownScope) {
            case USER: {
                return this.cooldownScope.genKey(this.name, event.getAuthor().getIdLong());
            }
            case USER_GUILD: {
                return event.getGuild() != null ? this.cooldownScope.genKey(this.name, event.getAuthor().getIdLong(), event.getGuild().getIdLong()) : CooldownScope.USER_CHANNEL.genKey(this.name, event.getAuthor().getIdLong(), event.getChannel().getIdLong());
            }
            case USER_CHANNEL: {
                return this.cooldownScope.genKey(this.name, event.getAuthor().getIdLong(), event.getChannel().getIdLong());
            }
            case GUILD: {
                return event.getGuild() != null ? this.cooldownScope.genKey(this.name, event.getGuild().getIdLong()) : CooldownScope.CHANNEL.genKey(this.name, event.getChannel().getIdLong());
            }
            case CHANNEL: {
                return this.cooldownScope.genKey(this.name, event.getChannel().getIdLong());
            }
            case SHARD: {
                return event.getJDA().getShardInfo() != null ? this.cooldownScope.genKey(this.name, event.getJDA().getShardInfo().getShardId()) : CooldownScope.GLOBAL.genKey(this.name, 0L);
            }
            case USER_SHARD: {
                return event.getJDA().getShardInfo() != null ? this.cooldownScope.genKey(this.name, event.getAuthor().getIdLong(), event.getJDA().getShardInfo().getShardId()) : CooldownScope.USER.genKey(this.name, event.getAuthor().getIdLong());
            }
            case GLOBAL: {
                return this.cooldownScope.genKey(this.name, 0L);
            }
        }
        return "";
    }

    public String getCooldownError(CommandEvent event, int remaining) {
        if (remaining <= 0) {
            return null;
        }
        String front = event.getClient().getWarning() + " That command is on cooldown for " + remaining + " more seconds";
        if (this.cooldownScope.equals((Object)CooldownScope.USER)) {
            return front + "!";
        }
        if (this.cooldownScope.equals((Object)CooldownScope.USER_GUILD) && event.getGuild() == null) {
            return front + " " + CooldownScope.USER_CHANNEL.errorSpecification + "!";
        }
        if (this.cooldownScope.equals((Object)CooldownScope.GUILD) && event.getGuild() == null) {
            return front + " " + CooldownScope.CHANNEL.errorSpecification + "!";
        }
        return front + " " + this.cooldownScope.errorSpecification + "!";
    }

    public static enum CooldownScope {
        USER("U:%d", ""),
        CHANNEL("C:%d", "in this channel"),
        USER_CHANNEL("U:%d|C:%d", "in this channel"),
        GUILD("G:%d", "in this server"),
        USER_GUILD("U:%d|G:%d", "in this server"),
        SHARD("S:%d", "on this shard"),
        USER_SHARD("U:%d|S:%d", "on this shard"),
        GLOBAL("Global", "globally");

        private final String format;
        final String errorSpecification;

        private CooldownScope(String format, String errorSpecification) {
            this.format = format;
            this.errorSpecification = errorSpecification;
        }

        String genKey(String name, long id) {
            return this.genKey(name, id, -1L);
        }

        String genKey(String name, long idOne, long idTwo) {
            if (this.equals((Object)GLOBAL)) {
                return name + "|" + this.format;
            }
            if (idTwo == -1L) {
                return name + "|" + String.format(this.format, idOne);
            }
            return name + "|" + String.format(this.format, idOne, idTwo);
        }
    }

    public static class Category {
        private final String name;
        private final String failResponse;
        private final Predicate<CommandEvent> predicate;

        public Category(String name) {
            this.name = name;
            this.failResponse = null;
            this.predicate = null;
        }

        public Category(String name, Predicate<CommandEvent> predicate) {
            this.name = name;
            this.failResponse = null;
            this.predicate = predicate;
        }

        public Category(String name, String failResponse, Predicate<CommandEvent> predicate) {
            this.name = name;
            this.failResponse = failResponse;
            this.predicate = predicate;
        }

        public String getName() {
            return this.name;
        }

        public String getFailureResponse() {
            return this.failResponse;
        }

        public boolean test(CommandEvent event) {
            return this.predicate == null || this.predicate.test(event);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Category)) {
                return false;
            }
            Category other = (Category)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.predicate, other.predicate) && Objects.equals(this.failResponse, other.failResponse);
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + Objects.hashCode(this.name);
            hash = 17 * hash + Objects.hashCode(this.failResponse);
            hash = 17 * hash + Objects.hashCode(this.predicate);
            return hash;
        }
    }
}

