/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.command.impl;

import com.jagrosh.jdautilities.command.AnnotatedModuleCompiler;
import com.jagrosh.jdautilities.command.Command;
import com.jagrosh.jdautilities.command.CommandClient;
import com.jagrosh.jdautilities.command.CommandEvent;
import com.jagrosh.jdautilities.command.CommandListener;
import com.jagrosh.jdautilities.command.GuildSettingsManager;
import com.jagrosh.jdautilities.command.GuildSettingsProvider;
import com.jagrosh.jdautilities.commons.utils.FixedSizeCache;
import com.jagrosh.jdautilities.commons.utils.SafeIdUtil;
import java.io.IOException;
import java.io.Reader;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildChannel;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.GenericEvent;
import net.dv8tion.jda.api.events.ReadyEvent;
import net.dv8tion.jda.api.events.ShutdownEvent;
import net.dv8tion.jda.api.events.guild.GuildJoinEvent;
import net.dv8tion.jda.api.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.guild.GuildMessageDeleteEvent;
import net.dv8tion.jda.api.hooks.EventListener;
import net.dv8tion.jda.internal.utils.Checks;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandClientImpl
implements CommandClient,
EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(CommandClient.class);
    private static final String DEFAULT_PREFIX = "@mention";
    private final OffsetDateTime start;
    private final Activity activity;
    private final OnlineStatus status;
    private final String ownerId;
    private final String[] coOwnerIds;
    private final String prefix;
    private final String altprefix;
    private final String serverInvite;
    private final HashMap<String, Integer> commandIndex;
    private final ArrayList<Command> commands;
    private final String success;
    private final String warning;
    private final String error;
    private final String botsKey;
    private final String carbonKey;
    private final HashMap<String, OffsetDateTime> cooldowns;
    private final HashMap<String, Integer> uses;
    private final FixedSizeCache<Long, Set<Message>> linkMap;
    private final boolean useHelp;
    private final boolean shutdownAutomatically;
    private final Consumer<CommandEvent> helpConsumer;
    private final String helpWord;
    private final ScheduledExecutorService executor;
    private final AnnotatedModuleCompiler compiler;
    private final GuildSettingsManager manager;
    private String textPrefix;
    private CommandListener listener = null;
    private int totalGuilds;

    public CommandClientImpl(String ownerId, String[] coOwnerIds, String prefix, String altprefix, Activity activity, OnlineStatus status, String serverInvite, String success, String warning, String error, String carbonKey, String botsKey, ArrayList<Command> commands, boolean useHelp, boolean shutdownAutomatically, Consumer<CommandEvent> helpConsumer, String helpWord, ScheduledExecutorService executor, int linkedCacheSize, AnnotatedModuleCompiler compiler, GuildSettingsManager manager) {
        Checks.check((ownerId != null ? 1 : 0) != 0, (String)"Owner ID was set null or not set! Please provide an User ID to register as the owner!");
        if (!SafeIdUtil.checkId((String)ownerId)) {
            LOG.warn(String.format("The provided Owner ID (%s) was found unsafe! Make sure ID is a non-negative long!", ownerId));
        }
        if (coOwnerIds != null) {
            for (String coOwnerId : coOwnerIds) {
                if (SafeIdUtil.checkId((String)coOwnerId)) continue;
                LOG.warn(String.format("The provided CoOwner ID (%s) was found unsafe! Make sure ID is a non-negative long!", coOwnerId));
            }
        }
        this.start = OffsetDateTime.now();
        this.ownerId = ownerId;
        this.coOwnerIds = coOwnerIds;
        this.prefix = prefix == null || prefix.isEmpty() ? DEFAULT_PREFIX : prefix;
        this.altprefix = altprefix == null || altprefix.isEmpty() ? null : altprefix;
        this.textPrefix = prefix;
        this.activity = activity;
        this.status = status;
        this.serverInvite = serverInvite;
        this.success = success == null ? "" : success;
        this.warning = warning == null ? "" : warning;
        this.error = error == null ? "" : error;
        this.carbonKey = carbonKey;
        this.botsKey = botsKey;
        this.commandIndex = new HashMap();
        this.commands = new ArrayList();
        this.cooldowns = new HashMap();
        this.uses = new HashMap();
        this.linkMap = linkedCacheSize > 0 ? new FixedSizeCache(linkedCacheSize) : null;
        this.useHelp = useHelp;
        this.shutdownAutomatically = shutdownAutomatically;
        this.helpWord = helpWord == null ? "help" : helpWord;
        this.executor = executor == null ? Executors.newSingleThreadScheduledExecutor() : executor;
        this.compiler = compiler;
        this.manager = manager;
        this.helpConsumer = helpConsumer == null ? event -> {
            StringBuilder builder = new StringBuilder("**" + event.getSelfUser().getName() + "** commands:\n");
            Command.Category category = null;
            for (Command command : commands) {
                if (command.isHidden() || command.isOwnerCommand() && !event.isOwner()) continue;
                if (!Objects.equals(category, command.getCategory())) {
                    category = command.getCategory();
                    builder.append("\n\n  __").append(category == null ? "No Category" : category.getName()).append("__:\n");
                }
                builder.append("\n`").append(this.textPrefix).append(prefix == null ? " " : "").append(command.getName()).append(command.getArguments() == null ? "`" : " " + command.getArguments() + "`").append(" - ").append(command.getHelp());
            }
            User owner = event.getJDA().getUserById(ownerId);
            if (owner != null) {
                builder.append("\n\nFor additional help, contact **").append(owner.getName()).append("**#").append(owner.getDiscriminator());
                if (serverInvite != null) {
                    builder.append(" or join ").append(serverInvite);
                }
            }
            event.replyInDm(builder.toString(), unused -> {
                if (event.isFromType(ChannelType.TEXT)) {
                    event.reactSuccess();
                }
            }, t -> event.replyWarning("Help cannot be sent because you are blocking Direct Messages."));
        } : helpConsumer;
        for (Command command : commands) {
            this.addCommand(command);
        }
    }

    @Override
    public void setListener(CommandListener listener) {
        this.listener = listener;
    }

    @Override
    public CommandListener getListener() {
        return this.listener;
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    public OffsetDateTime getStartTime() {
        return this.start;
    }

    @Override
    public OffsetDateTime getCooldown(String name) {
        return this.cooldowns.get(name);
    }

    @Override
    public int getRemainingCooldown(String name) {
        if (this.cooldowns.containsKey(name)) {
            int time = (int)Math.ceil((double)OffsetDateTime.now().until(this.cooldowns.get(name), ChronoUnit.MILLIS) / 1000.0);
            if (time <= 0) {
                this.cooldowns.remove(name);
                return 0;
            }
            return time;
        }
        return 0;
    }

    @Override
    public void applyCooldown(String name, int seconds) {
        this.cooldowns.put(name, OffsetDateTime.now().plusSeconds(seconds));
    }

    @Override
    public void cleanCooldowns() {
        OffsetDateTime now = OffsetDateTime.now();
        this.cooldowns.keySet().stream().filter(str -> this.cooldowns.get(str).isBefore(now)).collect(Collectors.toList()).forEach(this.cooldowns::remove);
    }

    @Override
    public int getCommandUses(Command command) {
        return this.getCommandUses(command.getName());
    }

    @Override
    public int getCommandUses(String name) {
        return this.uses.getOrDefault(name, 0);
    }

    @Override
    public void addCommand(Command command) {
        this.addCommand(command, this.commands.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommand(Command command, int index) {
        if (index > this.commands.size() || index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index specified is invalid: [" + index + "/" + this.commands.size() + "]");
        }
        HashMap<String, Integer> hashMap = this.commandIndex;
        synchronized (hashMap) {
            String name = command.getName().toLowerCase();
            if (this.commandIndex.containsKey(name)) {
                throw new IllegalArgumentException("Command added has a name or alias that has already been indexed: \"" + name + "\"!");
            }
            for (String alias : command.getAliases()) {
                if (!this.commandIndex.containsKey(alias.toLowerCase())) continue;
                throw new IllegalArgumentException("Command added has a name or alias that has already been indexed: \"" + alias + "\"!");
            }
            if (index < this.commands.size()) {
                this.commandIndex.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= index).collect(Collectors.toList()).forEach(entry -> this.commandIndex.put((String)entry.getKey(), (Integer)entry.getValue() + 1));
            }
            this.commandIndex.put(name, index);
            for (String alias : command.getAliases()) {
                this.commandIndex.put(alias.toLowerCase(), index);
            }
        }
        this.commands.add(index, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCommand(String name) {
        HashMap<String, Integer> hashMap = this.commandIndex;
        synchronized (hashMap) {
            if (!this.commandIndex.containsKey(name.toLowerCase())) {
                throw new IllegalArgumentException("Name provided is not indexed: \"" + name + "\"!");
            }
            int targetIndex = this.commandIndex.remove(name.toLowerCase());
            Command removedCommand = this.commands.remove(targetIndex);
            for (String alias : removedCommand.getAliases()) {
                this.commandIndex.remove(alias.toLowerCase());
            }
            this.commandIndex.entrySet().stream().filter(entry -> (Integer)entry.getValue() > targetIndex).collect(Collectors.toList()).forEach(entry -> this.commandIndex.put((String)entry.getKey(), (Integer)entry.getValue() - 1));
        }
    }

    @Override
    public void addAnnotatedModule(Object module) {
        this.compiler.compile(module).forEach(this::addCommand);
    }

    @Override
    public void addAnnotatedModule(Object module, Function<Command, Integer> mapFunction) {
        this.compiler.compile(module).forEach(command -> this.addCommand((Command)command, (Integer)mapFunction.apply((Command)command)));
    }

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    @Override
    public long getOwnerIdLong() {
        return Long.parseLong(this.ownerId);
    }

    @Override
    public String[] getCoOwnerIds() {
        return this.coOwnerIds;
    }

    @Override
    public long[] getCoOwnerIdsLong() {
        if (this.coOwnerIds == null) {
            return null;
        }
        long[] ids = new long[this.coOwnerIds.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Long.parseLong(this.coOwnerIds[i]);
        }
        return ids;
    }

    @Override
    public String getSuccess() {
        return this.success;
    }

    @Override
    public String getWarning() {
        return this.warning;
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public ScheduledExecutorService getScheduleExecutor() {
        return this.executor;
    }

    @Override
    public String getServerInvite() {
        return this.serverInvite;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getAltPrefix() {
        return this.altprefix;
    }

    @Override
    public String getTextualPrefix() {
        return this.textPrefix;
    }

    @Override
    public int getTotalGuilds() {
        return this.totalGuilds;
    }

    @Override
    public String getHelpWord() {
        return this.helpWord;
    }

    @Override
    public boolean usesLinkedDeletion() {
        return this.linkMap != null;
    }

    @Override
    public <S> S getSettingsFor(Guild guild) {
        if (this.manager == null) {
            return null;
        }
        return (S)this.manager.getSettings(guild);
    }

    @Override
    public <M extends GuildSettingsManager> M getSettingsManager() {
        return (M)this.manager;
    }

    @Override
    public void shutdown() {
        Object manager = this.getSettingsManager();
        if (manager != null) {
            manager.shutdown();
        }
        this.executor.shutdown();
    }

    public void onEvent(GenericEvent event) {
        if (event instanceof MessageReceivedEvent) {
            this.onMessageReceived((MessageReceivedEvent)event);
        } else if (event instanceof GuildMessageDeleteEvent && this.usesLinkedDeletion()) {
            this.onMessageDelete((GuildMessageDeleteEvent)event);
        } else if (event instanceof GuildJoinEvent) {
            if (((GuildJoinEvent)event).getGuild().getSelfMember().getTimeJoined().plusMinutes(10L).isAfter(OffsetDateTime.now())) {
                this.sendStats(event.getJDA());
            }
        } else if (event instanceof GuildLeaveEvent) {
            this.sendStats(event.getJDA());
        } else if (event instanceof ReadyEvent) {
            this.onReady((ReadyEvent)event);
        } else if (event instanceof ShutdownEvent && this.shutdownAutomatically) {
            this.shutdown();
        }
    }

    private void onReady(ReadyEvent event) {
        if (!event.getJDA().getSelfUser().isBot()) {
            LOG.error("JDA-Utilities does not support CLIENT accounts.");
            event.getJDA().shutdown();
            return;
        }
        this.textPrefix = this.prefix.equals(DEFAULT_PREFIX) ? "@" + event.getJDA().getSelfUser().getName() + " " : this.prefix;
        event.getJDA().getPresence().setPresence(this.status == null ? OnlineStatus.ONLINE : this.status, this.activity == null ? null : ("default".equals(this.activity.getName()) ? Activity.playing((String)("Type " + this.textPrefix + this.helpWord)) : this.activity));
        Object manager = this.getSettingsManager();
        if (manager != null) {
            manager.init();
        }
        this.sendStats(event.getJDA());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessageReceived(MessageReceivedEvent event) {
        Collection<String> prefixes;
        GuildSettingsProvider settings;
        if (event.getAuthor().isBot()) {
            return;
        }
        String[] parts = null;
        String rawContent = event.getMessage().getContentRaw();
        GuildSettingsProvider guildSettingsProvider = settings = event.isFromType(ChannelType.TEXT) ? this.provideSettings(event.getGuild()) : null;
        if ((this.prefix.equals(DEFAULT_PREFIX) || this.altprefix != null && this.altprefix.equals(DEFAULT_PREFIX)) && (rawContent.startsWith("<@" + event.getJDA().getSelfUser().getId() + ">") || rawContent.startsWith("<@!" + event.getJDA().getSelfUser().getId() + ">"))) {
            parts = CommandClientImpl.splitOnPrefixLength(rawContent, rawContent.indexOf(">") + 1);
        }
        if (parts == null && rawContent.toLowerCase().startsWith(this.prefix.toLowerCase())) {
            parts = CommandClientImpl.splitOnPrefixLength(rawContent, this.prefix.length());
        }
        if (parts == null && this.altprefix != null && rawContent.toLowerCase().startsWith(this.altprefix.toLowerCase())) {
            parts = CommandClientImpl.splitOnPrefixLength(rawContent, this.altprefix.length());
        }
        if (parts == null && settings != null && (prefixes = settings.getPrefixes()) != null) {
            for (String prefix : prefixes) {
                if (parts != null || !rawContent.toLowerCase().startsWith(prefix.toLowerCase())) continue;
                parts = CommandClientImpl.splitOnPrefixLength(rawContent, prefix.length());
            }
        }
        if (parts != null) {
            if (this.useHelp && parts[0].equalsIgnoreCase(this.helpWord)) {
                CommandEvent cevent = new CommandEvent(event, parts[1] == null ? "" : parts[1], this);
                if (this.listener != null) {
                    this.listener.onCommand(cevent, null);
                }
                this.helpConsumer.accept(cevent);
                if (this.listener != null) {
                    this.listener.onCompletedCommand(cevent, null);
                }
                return;
            }
            if (event.isFromType(ChannelType.PRIVATE) || event.getTextChannel().canTalk()) {
                Command command;
                String name = parts[0];
                String args = parts[1] == null ? "" : parts[1];
                HashMap<String, Integer> hashMap = this.commandIndex;
                synchronized (hashMap) {
                    int i = this.commandIndex.getOrDefault(name.toLowerCase(), -1);
                    command = i != -1 ? this.commands.get(i) : null;
                }
                if (command != null) {
                    CommandEvent cevent = new CommandEvent(event, args, this);
                    if (this.listener != null) {
                        this.listener.onCommand(cevent, command);
                    }
                    this.uses.put(command.getName(), this.uses.getOrDefault(command.getName(), 0) + 1);
                    command.run(cevent);
                    return;
                }
            }
        }
        if (this.listener != null) {
            this.listener.onNonCommandMessage(event);
        }
    }

    private void sendStats(JDA jda) {
        Request.Builder builder;
        OkHttpClient client = jda.getHttpClient();
        if (this.carbonKey != null) {
            FormBody.Builder bodyBuilder = new FormBody.Builder().add("key", this.carbonKey).add("servercount", Integer.toString(jda.getGuilds().size()));
            if (jda.getShardInfo() != null) {
                bodyBuilder.add("shard_id", Integer.toString(jda.getShardInfo().getShardId())).add("shard_count", Integer.toString(jda.getShardInfo().getShardTotal()));
            }
            builder = new Request.Builder().post((RequestBody)bodyBuilder.build()).url("https://www.carbonitex.net/discord/data/botdata.php");
            client.newCall(builder.build()).enqueue(new Callback(){

                public void onResponse(Call call, Response response) {
                    LOG.info("Successfully send information to carbonitex.net");
                    response.close();
                }

                public void onFailure(Call call, IOException e) {
                    LOG.error("Failed to send information to carbonitex.net ", (Throwable)e);
                }
            });
        }
        if (this.botsKey != null) {
            JSONObject body = new JSONObject().put("guildCount", jda.getGuilds().size());
            if (jda.getShardInfo() != null) {
                body.put("shardId", jda.getShardInfo().getShardId()).put("shardCount", jda.getShardInfo().getShardTotal());
            }
            builder = new Request.Builder().post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)body.toString())).url("https://discord.bots.gg/api/v1/bots/" + jda.getSelfUser().getId() + "/stats").header("Authorization", this.botsKey).header("Content-Type", "application/json");
            client.newCall(builder.build()).enqueue(new Callback(){

                public void onResponse(Call call, Response response) throws IOException {
                    if (response.isSuccessful()) {
                        LOG.info("Successfully sent information to discord.bots.gg");
                        try (Reader reader = response.body().charStream();){
                            CommandClientImpl.this.totalGuilds = new JSONObject(new JSONTokener(reader)).getInt("guildCount");
                        }
                        catch (Exception ex) {
                            LOG.error("Failed to retrieve bot shard information from discord.bots.gg ", (Throwable)ex);
                        }
                    } else {
                        LOG.error("Failed to send information to discord.bots.gg: " + response.body().string());
                    }
                    response.close();
                }

                public void onFailure(Call call, IOException e) {
                    LOG.error("Failed to send information to discord.bots.gg ", (Throwable)e);
                }
            });
        } else {
            this.totalGuilds = jda.getShardManager() != null ? (int)jda.getShardManager().getGuildCache().size() : (int)jda.getGuildCache().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessageDelete(GuildMessageDeleteEvent event) {
        FixedSizeCache<Long, Set<Message>> fixedSizeCache = this.linkMap;
        synchronized (fixedSizeCache) {
            if (this.linkMap.contains((Object)event.getMessageIdLong())) {
                Set messages = (Set)this.linkMap.get((Object)event.getMessageIdLong());
                if (messages.size() > 1 && event.getGuild().getSelfMember().hasPermission((GuildChannel)event.getChannel(), new Permission[]{Permission.MESSAGE_MANAGE})) {
                    event.getChannel().deleteMessages((Collection)messages).queue(unused -> {}, ignored -> {});
                } else if (messages.size() > 0) {
                    messages.forEach(m -> m.delete().queue(unused -> {}, ignored -> {}));
                }
            }
        }
    }

    private GuildSettingsProvider provideSettings(Guild guild) {
        Object settings = this.getSettingsFor(guild);
        if (settings != null && settings instanceof GuildSettingsProvider) {
            return (GuildSettingsProvider)settings;
        }
        return null;
    }

    private static String[] splitOnPrefixLength(String rawContent, int length) {
        return Arrays.copyOf(rawContent.substring(length).trim().split("\\s+", 2), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkIds(long callId, Message message) {
        if (!this.usesLinkedDeletion()) {
            return;
        }
        FixedSizeCache<Long, Set<Message>> fixedSizeCache = this.linkMap;
        synchronized (fixedSizeCache) {
            HashSet<Message> stored = (HashSet<Message>)this.linkMap.get((Object)callId);
            if (stored != null) {
                stored.add(message);
            } else {
                stored = new HashSet<Message>();
                stored.add(message);
                this.linkMap.add((Object)callId, stored);
            }
        }
    }
}

