/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.commons.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.dv8tion.jda.bot.sharding.ShardManager;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.utils.cache.SnowflakeCacheView;

public final class FinderUtil {
    public static final Pattern DISCORD_ID = Pattern.compile("\\d{17,20}");
    public static final Pattern FULL_USER_REF = Pattern.compile("(\\S.{0,30}\\S)\\s*#(\\d{4})");
    public static final Pattern USER_MENTION = Pattern.compile("<@!?(\\d{17,20})>");
    public static final Pattern CHANNEL_MENTION = Pattern.compile("<#(\\d{17,20})>");
    public static final Pattern ROLE_MENTION = Pattern.compile("<@&(\\d{17,20})>");
    public static final Pattern EMOTE_MENTION = Pattern.compile("<:(.{2,32}):(\\d{17,20})>");

    public static List<User> findUsers(String query, JDA jda) {
        return FinderUtil.jdaUserSearch(query, jda, true);
    }

    public static List<User> findShardUsers(String query, JDA jda) {
        return FinderUtil.jdaUserSearch(query, jda, false);
    }

    private static List<User> jdaUserSearch(String query, JDA jda, boolean useShardManager) {
        User user2;
        ShardManager manager;
        Matcher userMention = USER_MENTION.matcher(query);
        Matcher fullRefMatch = FULL_USER_REF.matcher(query);
        ShardManager shardManager = manager = useShardManager ? jda.asBot().getShardManager() : null;
        if (userMention.matches()) {
            User user3 = user2 = manager != null ? manager.getUserById(userMention.group(1)) : jda.getUserById(userMention.group(1));
            if (user2 != null) {
                return Collections.singletonList(user2);
            }
        } else if (fullRefMatch.matches()) {
            String lowerName = fullRefMatch.group(1).toLowerCase();
            String discrim = fullRefMatch.group(2);
            List<User> users = (manager != null ? manager.getUserCache() : jda.getUserCache()).stream().filter(user -> user.getName().toLowerCase().equals(lowerName) && user.getDiscriminator().equals(discrim)).collect(Collectors.toList());
            if (!users.isEmpty()) {
                return users;
            }
        } else if (DISCORD_ID.matcher(query).matches()) {
            User user4 = user2 = manager != null ? manager.getUserById(query) : jda.getUserById(query);
            if (user2 != null) {
                return Collections.singletonList(user2);
            }
        }
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        (manager != null ? manager.getUserCache() : jda.getUserCache()).forEach(user -> {
            String name = user.getName();
            if (name.equals(query)) {
                exact.add(user);
            } else if (name.equalsIgnoreCase(query) && exact.isEmpty()) {
                wrongcase.add(user);
            } else if (name.toLowerCase().startsWith(lowerquery) && wrongcase.isEmpty()) {
                startswith.add(user);
            } else if (name.toLowerCase().contains(lowerquery) && startswith.isEmpty()) {
                contains.add(user);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableList(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableList(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableList(startswith);
        }
        return Collections.unmodifiableList(contains);
    }

    public static List<User> findBannedUsers(String query, Guild guild) {
        List bans;
        try {
            bans = ((List)guild.getBanList().complete()).stream().map(Guild.Ban::getUser).collect(Collectors.toList());
        }
        catch (Exception e) {
            return null;
        }
        String discrim = null;
        Matcher userMention = USER_MENTION.matcher(query);
        if (userMention.matches()) {
            String id = userMention.group(1);
            User user = guild.getJDA().getUserById(id);
            if (user != null && bans.contains(user)) {
                return Collections.singletonList(user);
            }
            for (User u : bans) {
                if (!u.getId().equals(id)) continue;
                return Collections.singletonList(u);
            }
        } else if (FULL_USER_REF.matcher(query).matches()) {
            discrim = query.substring(query.length() - 4);
            query = query.substring(0, query.length() - 5).trim();
        } else if (DISCORD_ID.matcher(query).matches()) {
            User user = guild.getJDA().getUserById(query);
            if (user != null && bans.contains(user)) {
                return Collections.singletonList(user);
            }
            for (User u : bans) {
                if (!u.getId().equals(query)) continue;
                return Collections.singletonList(u);
            }
        }
        ArrayList<User> exact = new ArrayList<User>();
        ArrayList<User> wrongcase = new ArrayList<User>();
        ArrayList<User> startswith = new ArrayList<User>();
        ArrayList<User> contains = new ArrayList<User>();
        String lowerQuery = query.toLowerCase();
        for (User u : bans) {
            if (discrim != null && !u.getDiscriminator().equals(discrim)) continue;
            if (u.getName().equals(query)) {
                exact.add(u);
                continue;
            }
            if (exact.isEmpty() && u.getName().equalsIgnoreCase(query)) {
                wrongcase.add(u);
                continue;
            }
            if (wrongcase.isEmpty() && u.getName().toLowerCase().startsWith(lowerQuery)) {
                startswith.add(u);
                continue;
            }
            if (!startswith.isEmpty() || !u.getName().toLowerCase().contains(lowerQuery)) continue;
            contains.add(u);
        }
        if (!exact.isEmpty()) {
            return Collections.unmodifiableList(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableList(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableList(startswith);
        }
        return Collections.unmodifiableList(contains);
    }

    public static List<Member> findMembers(String query, Guild guild) {
        Member member2;
        Matcher userMention = USER_MENTION.matcher(query);
        Matcher fullRefMatch = FULL_USER_REF.matcher(query);
        if (userMention.matches()) {
            member2 = guild.getMemberById(userMention.group(1));
            if (member2 != null) {
                return Collections.singletonList(member2);
            }
        } else if (fullRefMatch.matches()) {
            String lowerName = fullRefMatch.group(1).toLowerCase();
            String discrim = fullRefMatch.group(2);
            List<Member> members = guild.getMemberCache().stream().filter(member -> member.getUser().getName().toLowerCase().equals(lowerName) && member.getUser().getDiscriminator().equals(discrim)).collect(Collectors.toList());
            if (!members.isEmpty()) {
                return members;
            }
        } else if (DISCORD_ID.matcher(query).matches() && (member2 = guild.getMemberById(query)) != null) {
            return Collections.singletonList(member2);
        }
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        guild.getMemberCache().forEach(member -> {
            String name = member.getUser().getName();
            String effName = member.getEffectiveName();
            if (name.equals(query) || effName.equals(query)) {
                exact.add(member);
            } else if ((name.equalsIgnoreCase(query) || effName.equalsIgnoreCase(query)) && exact.isEmpty()) {
                wrongcase.add(member);
            } else if ((name.toLowerCase().startsWith(lowerquery) || effName.toLowerCase().startsWith(lowerquery)) && wrongcase.isEmpty()) {
                startswith.add(member);
            } else if ((name.toLowerCase().contains(lowerquery) || effName.toLowerCase().contains(lowerquery)) && startswith.isEmpty()) {
                contains.add(member);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableList(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableList(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableList(startswith);
        }
        return Collections.unmodifiableList(contains);
    }

    public static List<TextChannel> findTextChannels(String query, JDA jda) {
        return FinderUtil.jdaTextChannelSearch(query, jda, true);
    }

    public static List<TextChannel> findShardTextChannels(String query, JDA jda) {
        return FinderUtil.jdaTextChannelSearch(query, jda, false);
    }

    public static List<TextChannel> findTextChannels(String query, Guild guild) {
        TextChannel tc;
        Matcher channelMention = CHANNEL_MENTION.matcher(query);
        if (channelMention.matches()) {
            TextChannel tc2 = guild.getTextChannelById(channelMention.group(1));
            if (tc2 != null) {
                return Collections.singletonList(tc2);
            }
        } else if (DISCORD_ID.matcher(query).matches() && (tc = guild.getTextChannelById(query)) != null) {
            return Collections.singletonList(tc);
        }
        return FinderUtil.genericTextChannelSearch(query, (SnowflakeCacheView<TextChannel>)guild.getTextChannelCache());
    }

    private static List<TextChannel> jdaTextChannelSearch(String query, JDA jda, boolean useShardManager) {
        ShardManager manager;
        Matcher channelMention = CHANNEL_MENTION.matcher(query);
        ShardManager shardManager = manager = useShardManager ? jda.asBot().getShardManager() : null;
        if (channelMention.matches()) {
            TextChannel tc;
            TextChannel textChannel = tc = manager != null ? manager.getTextChannelById(channelMention.group(1)) : jda.getTextChannelById(channelMention.group(1));
            if (tc != null) {
                return Collections.singletonList(tc);
            }
        } else if (DISCORD_ID.matcher(query).matches()) {
            TextChannel tc;
            TextChannel textChannel = tc = manager != null ? manager.getTextChannelById(query) : jda.getTextChannelById(query);
            if (tc != null) {
                return Collections.singletonList(tc);
            }
        }
        return FinderUtil.genericTextChannelSearch(query, (SnowflakeCacheView<TextChannel>)(manager != null ? manager.getTextChannelCache() : jda.getTextChannelCache()));
    }

    private static List<TextChannel> genericTextChannelSearch(String query, SnowflakeCacheView<TextChannel> cache) {
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        cache.forEach(tc -> {
            String name = tc.getName();
            if (name.equals(query)) {
                exact.add(tc);
            } else if (name.equalsIgnoreCase(query) && exact.isEmpty()) {
                wrongcase.add(tc);
            } else if (name.toLowerCase().startsWith(lowerquery) && wrongcase.isEmpty()) {
                startswith.add(tc);
            } else if (name.toLowerCase().contains(lowerquery) && startswith.isEmpty()) {
                contains.add(tc);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableList(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableList(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableList(startswith);
        }
        return Collections.unmodifiableList(contains);
    }

    public static List<VoiceChannel> findVoiceChannels(String query, JDA jda) {
        return FinderUtil.jdaVoiceChannelSearch(query, jda, true);
    }

    public static List<VoiceChannel> findShardVoiceChannels(String query, JDA jda) {
        return FinderUtil.jdaVoiceChannelSearch(query, jda, false);
    }

    public static List<VoiceChannel> findVoiceChannels(String query, Guild guild) {
        VoiceChannel vc;
        if (DISCORD_ID.matcher(query).matches() && (vc = guild.getVoiceChannelById(query)) != null) {
            return Collections.singletonList(vc);
        }
        return FinderUtil.genericVoiceChannelSearch(query, (SnowflakeCacheView<VoiceChannel>)guild.getVoiceChannelCache());
    }

    private static List<VoiceChannel> jdaVoiceChannelSearch(String query, JDA jda, boolean useShardManager) {
        ShardManager manager;
        ShardManager shardManager = manager = useShardManager ? jda.asBot().getShardManager() : null;
        if (DISCORD_ID.matcher(query).matches()) {
            VoiceChannel vc;
            VoiceChannel voiceChannel = vc = manager != null ? manager.getVoiceChannelById(query) : jda.getVoiceChannelById(query);
            if (vc != null) {
                return Collections.singletonList(vc);
            }
        }
        return FinderUtil.genericVoiceChannelSearch(query, (SnowflakeCacheView<VoiceChannel>)(manager != null ? manager.getVoiceChannelCache() : jda.getVoiceChannelCache()));
    }

    private static List<VoiceChannel> genericVoiceChannelSearch(String query, SnowflakeCacheView<VoiceChannel> cache) {
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        cache.forEach(vc -> {
            String name = vc.getName();
            if (name.equals(query)) {
                exact.add(vc);
            } else if (name.equalsIgnoreCase(query) && exact.isEmpty()) {
                wrongcase.add(vc);
            } else if (name.toLowerCase().startsWith(lowerquery) && wrongcase.isEmpty()) {
                startswith.add(vc);
            } else if (name.toLowerCase().contains(lowerquery) && startswith.isEmpty()) {
                contains.add(vc);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableList(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableList(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableList(startswith);
        }
        return Collections.unmodifiableList(contains);
    }

    public static List<Category> findCategories(String query, JDA jda) {
        return FinderUtil.jdaCategorySearch(query, jda, true);
    }

    public static List<Category> findShardCategories(String query, JDA jda) {
        return FinderUtil.jdaCategorySearch(query, jda, false);
    }

    public static List<Category> findCategories(String query, Guild guild) {
        Category cat;
        if (DISCORD_ID.matcher(query).matches() && (cat = guild.getCategoryById(query)) != null) {
            return Collections.singletonList(cat);
        }
        return FinderUtil.genericCategorySearch(query, (SnowflakeCacheView<Category>)guild.getCategoryCache());
    }

    private static List<Category> jdaCategorySearch(String query, JDA jda, boolean useShardManager) {
        ShardManager manager;
        ShardManager shardManager = manager = useShardManager ? jda.asBot().getShardManager() : null;
        if (DISCORD_ID.matcher(query).matches()) {
            Category cat;
            Category category = cat = manager != null ? manager.getCategoryById(query) : jda.getCategoryById(query);
            if (cat != null) {
                return Collections.singletonList(cat);
            }
        }
        return FinderUtil.genericCategorySearch(query, (SnowflakeCacheView<Category>)jda.getCategoryCache());
    }

    private static List<Category> genericCategorySearch(String query, SnowflakeCacheView<Category> cache) {
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        cache.forEach(cat -> {
            String name = cat.getName();
            if (name.equals(query)) {
                exact.add(cat);
            } else if (name.equalsIgnoreCase(query) && exact.isEmpty()) {
                wrongcase.add(cat);
            } else if (name.toLowerCase().startsWith(lowerquery) && wrongcase.isEmpty()) {
                startswith.add(cat);
            } else if (name.toLowerCase().contains(lowerquery) && startswith.isEmpty()) {
                contains.add(cat);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableList(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableList(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableList(startswith);
        }
        return Collections.unmodifiableList(contains);
    }

    public static List<Role> findRoles(String query, Guild guild) {
        Role role2;
        Matcher roleMention = ROLE_MENTION.matcher(query);
        if (roleMention.matches() ? (role2 = guild.getRoleById(roleMention.group(1))) != null && role2.isMentionable() : DISCORD_ID.matcher(query).matches() && (role2 = guild.getRoleById(query)) != null) {
            return Collections.singletonList(role2);
        }
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        guild.getRoleCache().forEach(role -> {
            String name = role.getName();
            if (name.equals(query)) {
                exact.add(role);
            } else if (name.equalsIgnoreCase(query) && exact.isEmpty()) {
                wrongcase.add(role);
            } else if (name.toLowerCase().startsWith(lowerquery) && wrongcase.isEmpty()) {
                startswith.add(role);
            } else if (name.toLowerCase().contains(lowerquery) && startswith.isEmpty()) {
                contains.add(role);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableList(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableList(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableList(startswith);
        }
        return Collections.unmodifiableList(contains);
    }

    public static List<Emote> findEmotes(String query, JDA jda) {
        return FinderUtil.jdaFindEmotes(query, jda, true);
    }

    public static List<Emote> findShardEmotes(String query, JDA jda) {
        return FinderUtil.jdaFindEmotes(query, jda, false);
    }

    public static List<Emote> findEmotes(String query, Guild guild) {
        Matcher mentionMatcher = EMOTE_MENTION.matcher(query);
        if (DISCORD_ID.matcher(query).matches()) {
            Emote emote = guild.getEmoteById(query);
            if (emote != null) {
                return Collections.singletonList(emote);
            }
        } else if (mentionMatcher.matches()) {
            String emoteName = mentionMatcher.group(1);
            String emoteId = mentionMatcher.group(2);
            Emote emote = guild.getEmoteById(emoteId);
            if (emote != null && emote.getName().equals(emoteName)) {
                return Collections.singletonList(emote);
            }
        }
        return FinderUtil.genericEmoteSearch(query, (SnowflakeCacheView<Emote>)guild.getEmoteCache());
    }

    private static List<Emote> jdaFindEmotes(String query, JDA jda, boolean useShardManager) {
        ShardManager manager;
        Matcher mentionMatcher = EMOTE_MENTION.matcher(query);
        ShardManager shardManager = manager = useShardManager ? jda.asBot().getShardManager() : null;
        if (DISCORD_ID.matcher(query).matches()) {
            Emote emote;
            Emote emote2 = emote = manager != null ? manager.getEmoteById(query) : jda.getEmoteById(query);
            if (emote != null) {
                return Collections.singletonList(emote);
            }
        } else if (mentionMatcher.matches()) {
            Emote emote;
            String emoteName = mentionMatcher.group(1);
            String emoteId = mentionMatcher.group(2);
            Emote emote3 = emote = manager != null ? manager.getEmoteById(emoteId) : jda.getEmoteById(emoteId);
            if (emote != null && emote.getName().equals(emoteName)) {
                return Collections.singletonList(emote);
            }
        }
        return FinderUtil.genericEmoteSearch(query, (SnowflakeCacheView<Emote>)jda.getEmoteCache());
    }

    private static List<Emote> genericEmoteSearch(String query, SnowflakeCacheView<Emote> cache) {
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        cache.forEach(emote -> {
            String name = emote.getName();
            if (name.equals(query)) {
                exact.add(emote);
            } else if (name.equalsIgnoreCase(query) && exact.isEmpty()) {
                wrongcase.add(emote);
            } else if (name.toLowerCase().startsWith(lowerquery) && wrongcase.isEmpty()) {
                startswith.add(emote);
            } else if (name.toLowerCase().contains(lowerquery) && startswith.isEmpty()) {
                contains.add(emote);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableList(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableList(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableList(startswith);
        }
        return Collections.unmodifiableList(contains);
    }

    private FinderUtil() {
    }
}

