/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.commons.waiter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dv8tion.jda.core.events.Event;
import net.dv8tion.jda.core.events.ShutdownEvent;
import net.dv8tion.jda.core.hooks.EventListener;
import net.dv8tion.jda.core.hooks.SubscribeEvent;
import net.dv8tion.jda.core.utils.Checks;

public class EventWaiter
implements EventListener {
    private final HashMap<Class<?>, Set<WaitingEvent>> waitingEvents;
    private final ScheduledExecutorService threadpool;
    private final boolean shutdownAutomatically;

    public EventWaiter() {
        this(Executors.newSingleThreadScheduledExecutor(), true);
    }

    public EventWaiter(ScheduledExecutorService threadpool, boolean shutdownAutomatically) {
        Checks.notNull((Object)threadpool, (String)"ScheduledExecutorService");
        Checks.check((!threadpool.isShutdown() ? 1 : 0) != 0, (String)"Cannot construct EventWaiter with a closed ScheduledExecutorService!");
        this.waitingEvents = new HashMap();
        this.threadpool = threadpool;
        this.shutdownAutomatically = shutdownAutomatically;
    }

    public boolean isShutdown() {
        return this.threadpool.isShutdown();
    }

    public <T extends Event> void waitForEvent(Class<T> classType, Predicate<T> condition, Consumer<T> action) {
        this.waitForEvent(classType, condition, action, -1L, null, null);
    }

    public <T extends Event> void waitForEvent(Class<T> classType, Predicate<T> condition, Consumer<T> action, long timeout, TimeUnit unit, Runnable timeoutAction) {
        Checks.check((!this.isShutdown() ? 1 : 0) != 0, (String)"Attempted to register a WaitingEvent while the EventWaiter's threadpool was already shut down!");
        Checks.notNull(classType, (String)"The provided class type");
        Checks.notNull(condition, (String)"The provided condition predicate");
        Checks.notNull(action, (String)"The provided action consumer");
        WaitingEvent we = new WaitingEvent(condition, action);
        Set set = this.waitingEvents.computeIfAbsent(classType, c -> new HashSet());
        set.add(we);
        if (timeout > 0L && unit != null) {
            this.threadpool.schedule(() -> {
                if (set.remove(we) && timeoutAction != null) {
                    timeoutAction.run();
                }
            }, timeout, unit);
        }
    }

    @SubscribeEvent
    public final void onEvent(Event event) {
        for (Class<?> c = event.getClass(); c != null; c = c.getSuperclass()) {
            if (this.waitingEvents.containsKey(c)) {
                Set<WaitingEvent> set = this.waitingEvents.get(c);
                WaitingEvent[] toRemove = set.toArray(new WaitingEvent[set.size()]);
                set.removeAll(Stream.of(toRemove).filter(i -> i.attempt(event)).collect(Collectors.toSet()));
            }
            if (!(event instanceof ShutdownEvent) || !this.shutdownAutomatically) continue;
            this.threadpool.shutdown();
        }
    }

    public void shutdown() {
        if (this.shutdownAutomatically) {
            throw new UnsupportedOperationException("Shutting down EventWaiters that are set to automatically close is unsupported!");
        }
        this.threadpool.shutdown();
    }

    private class WaitingEvent<T extends Event> {
        final Predicate<T> condition;
        final Consumer<T> action;

        WaitingEvent(Predicate<T> condition, Consumer<T> action) {
            this.condition = condition;
            this.action = action;
        }

        boolean attempt(T event) {
            if (this.condition.test(event)) {
                this.action.accept(event);
                return true;
            }
            return false;
        }
    }
}

