/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.menu;

import com.jagrosh.jdautilities.commons.waiter.EventWaiter;
import com.jagrosh.jdautilities.menu.Menu;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.MessageBuilder;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.internal.utils.Checks;

public class ButtonMenu
extends Menu {
    private final Color color;
    private final String text;
    private final String description;
    private final List<String> choices;
    private final Consumer<MessageReaction.ReactionEmote> action;
    private final Consumer<Message> finalAction;

    ButtonMenu(EventWaiter waiter, Set<User> users, Set<Role> roles, long timeout, TimeUnit unit, Color color, String text, String description, List<String> choices, Consumer<MessageReaction.ReactionEmote> action, Consumer<Message> finalAction) {
        super(waiter, users, roles, timeout, unit);
        this.color = color;
        this.text = text;
        this.description = description;
        this.choices = choices;
        this.action = action;
        this.finalAction = finalAction;
    }

    @Override
    public void display(MessageChannel channel) {
        this.initialize((RestAction<Message>)channel.sendMessage(this.getMessage()));
    }

    @Override
    public void display(Message message) {
        this.initialize((RestAction<Message>)message.editMessage(this.getMessage()));
    }

    private void initialize(RestAction<Message> ra) {
        ra.queue(m -> {
            for (int i = 0; i < this.choices.size(); ++i) {
                RestAction r;
                Emote emote;
                try {
                    emote = m.getJDA().getEmoteById(this.choices.get(i));
                }
                catch (Exception e) {
                    emote = null;
                }
                RestAction restAction = r = emote == null ? m.addReaction(this.choices.get(i)) : m.addReaction(emote);
                if (i + 1 < this.choices.size()) {
                    r.queue();
                    continue;
                }
                r.queue(v -> this.waiter.waitForEvent(MessageReactionAddEvent.class, event -> {
                    String re;
                    if (!event.getMessageId().equals(m.getId())) {
                        return false;
                    }
                    String string = re = event.getReaction().getReactionEmote().isEmote() ? event.getReaction().getReactionEmote().getId() : event.getReaction().getReactionEmote().getName();
                    if (!this.choices.contains(re)) {
                        return false;
                    }
                    return this.isValidUser(event.getUser(), event.isFromGuild() ? event.getGuild() : null);
                }, event -> {
                    this.action.accept(event.getReaction().getReactionEmote());
                    this.finalAction.accept((Message)m);
                }, this.timeout, this.unit, () -> this.finalAction.accept((Message)m)));
            }
        });
    }

    private Message getMessage() {
        MessageBuilder mbuilder = new MessageBuilder();
        if (this.text != null) {
            mbuilder.append((CharSequence)this.text);
        }
        if (this.description != null) {
            mbuilder.setEmbed(new EmbedBuilder().setColor(this.color).setDescription((CharSequence)this.description).build());
        }
        return mbuilder.build();
    }

    public static class Builder
    extends Menu.Builder<Builder, ButtonMenu> {
        private Color color;
        private String text;
        private String description;
        private final List<String> choices = new LinkedList<String>();
        private Consumer<MessageReaction.ReactionEmote> action;
        private Consumer<Message> finalAction = m -> {};

        @Override
        public ButtonMenu build() {
            Checks.check((this.waiter != null ? 1 : 0) != 0, (String)"Must set an EventWaiter");
            Checks.check((!this.choices.isEmpty() ? 1 : 0) != 0, (String)"Must have at least one choice");
            Checks.check((this.action != null ? 1 : 0) != 0, (String)"Must provide an action consumer");
            Checks.check((this.text != null || this.description != null ? 1 : 0) != 0, (String)"Either text or description must be set");
            return new ButtonMenu(this.waiter, this.users, this.roles, this.timeout, this.unit, this.color, this.text, this.description, this.choices, this.action, this.finalAction);
        }

        public Builder setColor(Color color) {
            this.color = color;
            return this;
        }

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setAction(Consumer<MessageReaction.ReactionEmote> action) {
            this.action = action;
            return this;
        }

        public Builder setFinalAction(Consumer<Message> finalAction) {
            this.finalAction = finalAction;
            return this;
        }

        public Builder addChoice(String emoji) {
            this.choices.add(emoji);
            return this;
        }

        public Builder addChoice(Emote emote) {
            return this.addChoice(emote.getId());
        }

        public Builder addChoices(String ... emojis) {
            for (String emoji : emojis) {
                this.addChoice(emoji);
            }
            return this;
        }

        public Builder addChoices(Emote ... emotes) {
            for (Emote emote : emotes) {
                this.addChoice(emote);
            }
            return this;
        }

        public Builder setChoices(String ... emojis) {
            this.choices.clear();
            return this.addChoices(emojis);
        }

        public Builder setChoices(Emote ... emotes) {
            this.choices.clear();
            return this.addChoices(emotes);
        }
    }
}

