/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.oauth2;

import com.jagrosh.jdautilities.oauth2.Scope;
import com.jagrosh.jdautilities.oauth2.entities.OAuth2Guild;
import com.jagrosh.jdautilities.oauth2.entities.OAuth2User;
import com.jagrosh.jdautilities.oauth2.entities.impl.OAuth2ClientImpl;
import com.jagrosh.jdautilities.oauth2.exceptions.InvalidStateException;
import com.jagrosh.jdautilities.oauth2.requests.OAuth2Action;
import com.jagrosh.jdautilities.oauth2.session.Session;
import com.jagrosh.jdautilities.oauth2.session.SessionController;
import com.jagrosh.jdautilities.oauth2.state.StateController;
import java.util.List;
import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.internal.utils.Checks;
import okhttp3.OkHttpClient;

public interface OAuth2Client {
    public static final int DISCORD_REST_VERSION = 6;

    public String generateAuthorizationURL(String var1, Scope ... var2);

    @CheckReturnValue
    public OAuth2Action<Session> startSession(String var1, String var2, String var3, Scope ... var4) throws InvalidStateException;

    @CheckReturnValue
    public OAuth2Action<OAuth2User> getUser(Session var1);

    @CheckReturnValue
    public OAuth2Action<List<OAuth2Guild>> getGuilds(Session var1);

    public long getId();

    public String getSecret();

    public StateController getStateController();

    public SessionController getSessionController();

    public static class Builder {
        private long clientId = -1L;
        private String clientSecret;
        private SessionController sessionController;
        private StateController stateController;
        private OkHttpClient client;

        public OAuth2Client build() {
            Checks.check((this.clientId >= 0L ? 1 : 0) != 0, (String)"Client ID is invalid!");
            Checks.notEmpty((CharSequence)this.clientSecret, (String)"Client Secret");
            return new OAuth2ClientImpl(this.clientId, this.clientSecret, this.sessionController, this.stateController, this.client);
        }

        public Builder setClientId(long clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setSessionController(SessionController sessionController) {
            this.sessionController = sessionController;
            return this;
        }

        public Builder setStateController(StateController stateController) {
            this.stateController = stateController;
            return this;
        }

        public Builder setOkHttpClient(OkHttpClient client) {
            this.client = client;
            return this;
        }
    }
}

