/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.jdautilities.oauth2.entities.impl;

import com.jagrosh.jdautilities.oauth2.OAuth2Client;
import com.jagrosh.jdautilities.oauth2.Scope;
import com.jagrosh.jdautilities.oauth2.entities.OAuth2Guild;
import com.jagrosh.jdautilities.oauth2.entities.OAuth2User;
import com.jagrosh.jdautilities.oauth2.entities.impl.OAuth2GuildImpl;
import com.jagrosh.jdautilities.oauth2.entities.impl.OAuth2UserImpl;
import com.jagrosh.jdautilities.oauth2.exceptions.InvalidStateException;
import com.jagrosh.jdautilities.oauth2.exceptions.MissingScopeException;
import com.jagrosh.jdautilities.oauth2.requests.OAuth2Action;
import com.jagrosh.jdautilities.oauth2.requests.OAuth2Requester;
import com.jagrosh.jdautilities.oauth2.requests.OAuth2URL;
import com.jagrosh.jdautilities.oauth2.session.DefaultSessionController;
import com.jagrosh.jdautilities.oauth2.session.Session;
import com.jagrosh.jdautilities.oauth2.session.SessionController;
import com.jagrosh.jdautilities.oauth2.session.SessionData;
import com.jagrosh.jdautilities.oauth2.state.DefaultStateController;
import com.jagrosh.jdautilities.oauth2.state.StateController;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.api.exceptions.HttpException;
import net.dv8tion.jda.internal.requests.Method;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.EncodingUtil;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.dv8tion.jda.internal.utils.JDALogger;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;

public class OAuth2ClientImpl
implements OAuth2Client {
    private static final Logger LOG = JDALogger.getLog(OAuth2Client.class);
    private final long clientId;
    private final String clientSecret;
    private final SessionController sessionController;
    private final StateController stateController;
    private final OkHttpClient httpClient;
    private final OAuth2Requester requester;

    public OAuth2ClientImpl(long clientId, String clientSecret, SessionController sessionController, StateController stateController, OkHttpClient httpClient) {
        Checks.check((clientId >= 0L ? 1 : 0) != 0, (String)"Invalid Client ID");
        Checks.notNull((Object)clientSecret, (String)"Client Secret");
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.sessionController = sessionController == null ? new DefaultSessionController() : sessionController;
        this.stateController = stateController == null ? new DefaultStateController() : stateController;
        this.httpClient = httpClient == null ? new OkHttpClient.Builder().build() : httpClient;
        this.requester = new OAuth2Requester(this.httpClient);
    }

    @Override
    public String generateAuthorizationURL(String redirectUri, Scope ... scopes) {
        Checks.notNull((Object)redirectUri, (String)"Redirect URI");
        return OAuth2URL.AUTHORIZE.compile(this.clientId, EncodingUtil.encodeUTF8((String)redirectUri), Scope.join(scopes), this.stateController.generateNewState(redirectUri));
    }

    @Override
    public OAuth2Action<Session> startSession(final String code, String state, final String identifier, final Scope ... scopes) throws InvalidStateException {
        Checks.notEmpty((CharSequence)code, (String)"code");
        Checks.notEmpty((CharSequence)state, (String)"state");
        final String redirectUri = this.stateController.consumeState(state);
        if (redirectUri == null) {
            throw new InvalidStateException(String.format("No state '%s' exists!", state));
        }
        final OAuth2URL oAuth2URL = OAuth2URL.TOKEN;
        return new OAuth2Action<Session>(this, Method.POST, oAuth2URL.getRouteWithBaseUrl()){

            @Override
            protected Headers getHeaders() {
                return Headers.of((String[])new String[]{"Content-Type", "x-www-form-urlencoded"});
            }

            @Override
            protected RequestBody getBody() {
                return RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (String)oAuth2URL.compileQueryParams(OAuth2ClientImpl.this.clientId, EncodingUtil.encodeUTF8((String)redirectUri), code, OAuth2ClientImpl.this.clientSecret, Scope.join(true, scopes)));
            }

            @Override
            protected Session handle(Response response) throws IOException {
                if (!response.isSuccessful()) {
                    throw OAuth2ClientImpl.failure(response);
                }
                JSONObject body = new JSONObject(new JSONTokener(IOUtil.getBody((Response)response)));
                String[] scopeStrings = body.getString("scope").split(" ");
                Scope[] scopes2 = new Scope[scopeStrings.length];
                for (int i = 0; i < scopeStrings.length; ++i) {
                    scopes2[i] = Scope.from(scopeStrings[i]);
                }
                return OAuth2ClientImpl.this.sessionController.createSession(new SessionData(identifier, body.getString("access_token"), body.getString("refresh_token"), body.getString("token_type"), OffsetDateTime.now().plusSeconds(body.getInt("expires_in")), scopes2));
            }
        };
    }

    @Override
    public OAuth2Action<OAuth2User> getUser(final Session session) {
        Checks.notNull((Object)session, (String)"Session");
        return new OAuth2Action<OAuth2User>(this, Method.GET, OAuth2URL.CURRENT_USER.compile(new Object[0])){

            @Override
            protected Headers getHeaders() {
                return Headers.of((String[])new String[]{"Authorization", OAuth2ClientImpl.this.generateAuthorizationHeader(session)});
            }

            @Override
            protected OAuth2User handle(Response response) throws IOException {
                if (!response.isSuccessful()) {
                    throw OAuth2ClientImpl.failure(response);
                }
                JSONObject body = new JSONObject(new JSONTokener(IOUtil.getBody((Response)response)));
                return new OAuth2UserImpl(OAuth2ClientImpl.this, session, body.getLong("id"), body.getString("username"), body.getString("discriminator"), body.optString("avatar", null), body.optString("email", null), body.optBoolean("verified", false), body.getBoolean("mfa_enabled"));
            }
        };
    }

    @Override
    public OAuth2Action<List<OAuth2Guild>> getGuilds(final Session session) {
        Checks.notNull((Object)session, (String)"session");
        if (!Scope.contains(session.getScopes(), Scope.GUILDS)) {
            throw new MissingScopeException("get guilds for a Session", Scope.GUILDS);
        }
        return new OAuth2Action<List<OAuth2Guild>>(this, Method.GET, OAuth2URL.CURRENT_USER_GUILDS.compile(new Object[0])){

            @Override
            protected Headers getHeaders() {
                return Headers.of((String[])new String[]{"Authorization", OAuth2ClientImpl.this.generateAuthorizationHeader(session)});
            }

            @Override
            protected List<OAuth2Guild> handle(Response response) throws IOException {
                if (!response.isSuccessful()) {
                    throw OAuth2ClientImpl.failure(response);
                }
                JSONArray body = new JSONArray(new JSONTokener(IOUtil.getBody((Response)response)));
                LinkedList<OAuth2Guild> list = new LinkedList<OAuth2Guild>();
                for (int i = 0; i < body.length(); ++i) {
                    JSONObject obj = body.getJSONObject(i);
                    list.add(new OAuth2GuildImpl(OAuth2ClientImpl.this, obj.getLong("id"), obj.getString("name"), obj.optString("icon", null), obj.getBoolean("owner"), obj.getInt("permissions")));
                }
                return list;
            }
        };
    }

    @Override
    public long getId() {
        return this.clientId;
    }

    @Override
    public String getSecret() {
        return this.clientSecret;
    }

    @Override
    public StateController getStateController() {
        return this.stateController;
    }

    @Override
    public SessionController getSessionController() {
        return this.sessionController;
    }

    public void shutdown() {
        this.httpClient.dispatcher().executorService().shutdown();
    }

    public OAuth2Requester getRequester() {
        return this.requester;
    }

    protected static HttpException failure(Response response) throws IOException {
        InputStream stream = IOUtil.getBody((Response)response);
        String responseBody = new String(IOUtil.readFully((InputStream)stream));
        return new HttpException("Request returned failure " + response.code() + ": " + responseBody);
    }

    private String generateAuthorizationHeader(Session session) {
        return String.format("%s %s", session.getTokenType(), session.getAccessToken());
    }
}

